unit EditMandatoryDatesDialog;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, Vcl.Forms, Vcl.Controls, Vcl.StdCtrls, Vcl.ComCtrls,
  System.Classes, Vcl.ExtCtrls, PlanTypes, SysUtils, Dialogs, PlanUtils;

type
  TFormEditMandatoryDatesDialog = class(TForm)
    ButtonOK: TButton;
    PanelBottom: TPanel;
    ButtonCancel: TButton;
    DateTimePicker1: TDateTimePicker;
    Label1: TLabel;
    DateTimePicker2: TDateTimePicker;
    Label2: TLabel;
    Label3: TLabel;
    ComboBox1: TComboBox;
    procedure ButtonOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
  public
  end;

function EditMandatoryDate(Value: TPlanMandatoryTime): boolean;

implementation

{$R *.dfm}


function EditMandatoryDate(Value: TPlanMandatoryTime): boolean;
var
  Form: TFormEditMandatoryDatesDialog;
begin
  Form := TFormEditMandatoryDatesDialog.Create(nil);
  Form.DateTimePicker1.Date := Value.DateFrom;
  Form.DateTimePicker2.Date := Value.DateTo;
  Form.ComboBox1.ItemIndex := Form.ComboBox1.Items.IndexOf(IntToStr(Value.GameCount));

  if mrOk = Form.ShowModal then
  begin
    Value.DateFrom := Trunc(Form.DateTimePicker1.Date);
    Value.DateTo := Trunc(Form.DateTimePicker2.Date);
    Value.GameCount := StrToInt(Form.ComboBox1.Items[Form.ComboBox1.ItemIndex]);
    Result := True;
  end
  else
  begin
    Result := False;
  end;

  Form.Free;

end;

procedure TFormEditMandatoryDatesDialog.ButtonOKClick(Sender: TObject);
begin
  if Trunc(DateTimePicker1.Date) > Trunc(DateTimePicker2.Date) then
  begin
    ShowMessage('Das "bis" Datum darf nicht kleiner als das "von" Datum sein');
  end
  else
  begin
    ModalResult := mrOk;
  end;
end;

procedure TFormEditMandatoryDatesDialog.FormCreate(Sender: TObject);
begin
  FixControls(Self);
end;

end.
