unit DialogSavePlan;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  System.UITypes, Winapi.Windows, Winapi.Messages, Vcl.StdCtrls, Vcl.Controls, Vcl.ExtCtrls, Vcl.Forms, System.SysUtils,
  Vcl.ComCtrls, System.Classes, PlanTypes, System.Generics.Collections, System.Generics.Defaults,
  Dialogs, Vcl.Menus, PlanUtils, Winapi.ShellAPI;

type
  TFormSavePlan = class(TForm)
    ButtonOK: TButton;
    PanelBottom: TPanel;
    ListPlans: TListView;
    Label1: TLabel;
    ButtonCancel: TButton;
    Label2: TLabel;
    EditName: TEdit;
    PopupMenuPlans: TPopupMenu;
    Lschen1: TMenuItem;
    LinkLabel1: TLabel;
    procedure ButtonOKClick(Sender: TObject);
    procedure ListPlansClick(Sender: TObject);
    procedure Lschen1Click(Sender: TObject);
    procedure LinkLabel1Click(Sender: TObject);
    procedure ButtonCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    function PlanExists(PlanName: String): boolean;
  public
    { Public-Deklarationen }
    CurrentPlanDirectory: String;
    procedure FillPlans(SavedPlans: TObjectList<TSavedPlan>);
  end;

function ShowDialogSavePlan(CurrentPlanDirectory: String; SavedPlans: TObjectList<TSavedPlan>; var ResultValue: String): boolean;

implementation

{$R *.dfm}


function ShowDialogSavePlan(CurrentPlanDirectory: String; SavedPlans: TObjectList<TSavedPlan>; var ResultValue: String): boolean;
var
  Dlg: TFormSavePlan;
begin
  Result := False;
  Dlg := TFormSavePlan.Create(nil);
  Dlg.FillPlans(SavedPlans);
  Dlg.CurrentPlanDirectory := CurrentPlanDirectory;
  if mrOk = Dlg.ShowModal() then
  begin
    ResultValue := Trim(Dlg.EditName.Text);
    Result := True;
  end;
  Dlg.Free;
end;

function TFormSavePlan.PlanExists(PlanName: String): boolean;
var
  i: Integer;
begin
  Result := False;
  for i := 0 to ListPlans.Items.Count-1 do
  begin
    if AnsiUpperCase(PlanName) = AnsiUpperCase(ListPlans.Items[i].Caption) then
    begin
      Result := True;
    end;
  end;
end;


procedure TFormSavePlan.ButtonCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TFormSavePlan.ButtonOKClick(Sender: TObject);
var
  S: String;
begin
  S := Trim(EditName.Text);
  if S <> '' then
  begin
    if PlanExists(S) then
    begin
      if mrYes <> MessageDlg('"' + S + '" existiert bereits, mchten Sie den Plan berschreiben?', mtConfirmation, [mbYes, mbNo], 0) then
      begin
        Exit;
      end;
    end;

    ModalResult := mrOK;
  end
  else
  begin
    ShowMessage('Bitte geben Sie einen Namen ein.');
  end;
end;

procedure TFormSavePlan.FillPlans(SavedPlans: TObjectList<TSavedPlan>);
var
  SavedPlan: TSavedPlan;
begin
  for SavedPlan in SavedPlans do
  begin
    ListPlans.AddItem(SavedPlan.Name, nil);
  end;

end;

procedure TFormSavePlan.FormCreate(Sender: TObject);
begin
  FixControls(Self);
end;

procedure TFormSavePlan.LinkLabel1Click(Sender: TObject);
begin
  ShellExecute(0, nil, pChar(CurrentPlanDirectory), nil, nil, SW_SHOW);
end;

procedure TFormSavePlan.ListPlansClick(Sender: TObject);
begin
  EditName.Text := ListPlans.Selected.Caption;
end;

procedure TFormSavePlan.Lschen1Click(Sender: TObject);
begin
  if Assigned(ListPlans.Selected) then
  begin
    EditName.Text := '';
    if mrYes = MessageDlg('"' + ListPlans.Selected.Caption + '" lschen?', mtConfirmation, [mbYes, mbNo], 0) then
    begin
      DeleteFile(CurrentPlanDirectory + '\' + EncodeFileName(ListPlans.Selected.Caption) + '.xml');
      ListPlans.Items.Delete(ListPlans.Items.IndexOf(ListPlans.Selected));
    end;
  end;

end;

end.
