unit DialogQuestionUseUserOptions;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils;

type
  TFormQuestionUseUserSettings = class(TForm)
    ButtonCancel: TButton;
    ButtonOK: TButton;
    Label1: TLabel;
    Memo: TMemo;
    procedure ButtonOKClick(Sender: TObject);
    procedure ButtonCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
  public
  end;


function DialogUseOptionsQuestion(Messages: TStrings): boolean;


implementation

{$R *.dfm}

function DialogUseOptionsQuestion(Messages: TStrings): boolean;
var
  Form: TFormQuestionUseUserSettings;
begin
  Form := TFormQuestionUseUserSettings.Create(nil);
  Form.Memo.Lines := Messages;
  if IDNO <> Form.ShowModal then
  begin
    Result := True;
  end
  else
  begin
    Result := False;
  end;

  Form.Release;

end;

procedure TFormQuestionUseUserSettings.ButtonCancelClick(Sender: TObject);
begin
  ModalResult := mrNo;
end;

procedure TFormQuestionUseUserSettings.ButtonOKClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

procedure TFormQuestionUseUserSettings.FormCreate(Sender: TObject);
begin
  FixControls(Self);
end;

end.
