unit DialogQuestionHardErrors;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils;

type
  TFormQuestionHardErrors = class(TForm)
    ButtonCancel: TButton;
    ButtonOK: TButton;
    Label1: TLabel;
    Memo: TMemo;
    Image1: TImage;
    Label2: TLabel;
    procedure ButtonOKClick(Sender: TObject);
    procedure ButtonCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
  public
  end;


function DialogHardErrors(Messages: TStrings): boolean;


implementation

{$R *.dfm}

function DialogHardErrors(Messages: TStrings): boolean;
var
  Form: TFormQuestionHardErrors;
begin
  Form := TFormQuestionHardErrors.Create(nil);
  Form.Memo.Lines := Messages;
  if mrOK = Form.ShowModal then
  begin
    Result := True;
  end
  else
  begin
    Result := False;
  end;

  Form.Release;

end;

procedure TFormQuestionHardErrors.ButtonCancelClick(Sender: TObject);
begin
  ModalResult := mrNo;
end;

procedure TFormQuestionHardErrors.ButtonOKClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

procedure TFormQuestionHardErrors.FormCreate(Sender: TObject);
begin
  FixControls(Self);
end;

end.
