unit DialogPanelTeams;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, EditMandatoryDatesDialog, Vcl.Menus, DialogPanelOptionArray, DialogForSingleGewichtungsOptions,
  DialogPanel, PlanDataObjects, DialogEditTeamName, System.UITypes;

type
  TDialogPanelTeams = class(TDialogPanel)
    PanelMain: TPanel;
    PanelMandatoryDatesTop: TPanel;
    ButtonTeamDelete: TButton;
    ButtonTeamEdit: TButton;
    ButtonTeamNew: TButton;
    ListBoxTeams: TListBox;
    Label1: TLabel;
    procedure ControlChange(Sender: TObject);
    procedure ButtonTeamEditClick(Sender: TObject);
    procedure ButtonTeamDeleteClick(Sender: TObject);
    procedure ListBoxTeamsClick(Sender: TObject);
    procedure ButtonTeamNewClick(Sender: TObject);
    procedure ListBoxTeamsDblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    procedure EnableButtons();
  public
    procedure setPanel(PanelMain: TPanel); override;
    procedure DataToForm(); override;
    procedure FormToData(); override;
    procedure toDefault(); override;
    function  isDefault(): boolean; override;

  end;


implementation

{$R *.dfm}



{ TDialogPanelFreeDays }

procedure TDialogPanelTeams.DataToForm;
var
  OldIndex: integer;
begin
  OldIndex := ListBoxTeams.ItemIndex;
  PlanData.getTeamNames(ListBoxTeams.Items);

  if (OldIndex >= 0) and (OldIndex < ListBoxTeams.Items.Count) then
  begin
    ListBoxTeams.ItemIndex := OldIndex;
  end;

  EnableButtons();
end;


procedure TDialogPanelTeams.EnableButtons;
begin
  ButtonTeamDelete.Enabled := ListBoxTeams.ItemIndex >= 0;
  ButtonTeamEdit.Enabled := ListBoxTeams.ItemIndex >= 0;
end;

procedure TDialogPanelTeams.ButtonTeamDeleteClick(Sender: TObject);
var
  TeamName: String;
  TeamNode: TDataObject;
begin
  if ListBoxTeams.ItemIndex >= 0  then
  begin
    TeamName := ListBoxTeams.Items[ListBoxTeams.ItemIndex];
    if mrYes = MessageDlg('Mchten Sie die Mannschaft ' + TeamName + ' wirklich lschen?', mtConfirmation, [mbYes, mbNo], 0) then
    begin
      for TeamNode in PlanData.root.NamedChilds(nTeam) do
      begin
        if TeamNode.GetAsString(aTeamName) = TeamName then
        begin
          PlanData.root.RemoveChild(TeamNode);
          DataToForm();
          FireOnChange();
          break;
        end;
      end;
    end;
  end;
end;

procedure TDialogPanelTeams.ButtonTeamEditClick(Sender: TObject);
var
  TeamName, TeamId, ClubId: String;
  TeamNumber: integer;
  DialogResult: integer;
  Dialog: TFormEditTeamName;
  OrgTeamNode, TeamNode: TDataObject;
  Valid: boolean;
  DefaultLocation: String;
begin
  if ListBoxTeams.ItemIndex >= 0  then
  begin
    TeamName := ListBoxTeams.Items[ListBoxTeams.ItemIndex];

    OrgTeamNode := nil;

    for OrgTeamNode in PlanData.root.NamedChilds(nTeam) do
    begin
      if OrgTeamNode.GetAsString(aTeamName) = TeamName then
      begin
        // TeamNode gefunden
        break;
      end;
    end;

    TeamName := OrgTeamNode.GetAsString(aTeamName);
    TeamId := OrgTeamNode.GetAsString(aTeamId);
    TeamNumber := OrgTeamNode.GetAsInt(aTeamNumber);
    ClubId := OrgTeamNode.GetAsString(aClubID);
    DefaultLocation := PlanData.FixLocation(OrgTeamNode.GetAsString(aLocation));

    Dialog := TFormEditTeamName.Create(Self);
    while True do
    begin
      Dialog.SetValues(PlanData, TeamName, TeamNumber, TeamId, ClubId, DefaultLocation);

      DialogResult := Dialog.ShowModal;

      if DialogResult = mrCancel then
      begin
        break;
      end;

      Dialog.GetValues(TeamName, TeamNumber, TeamId, ClubId, DefaultLocation);

      Valid := true;

      for TeamNode in PlanData.root.NamedChilds(nTeam) do
      begin
        if TeamNode <> OrgTeamNode then
        begin
          if TeamName = TeamNode.GetAsString(aTeamName) then
          begin
            ShowMessage('Mannschaftsname ist nicht eindeutig');
            Valid := False;
            break;
          end;
          if TeamName = TeamNode.GetAsString(aTeamId) then
          begin
            ShowMessage('Mannschafts-ID ist nicht eindeutig');
            Valid := False;
            break;
          end;
          if (TeamNumber = TeamNode.GetAsInt(aTeamNumber)) and (ClubId = TeamNode.GetAsString(aClubID)) then
          begin
            ShowMessage('Zu diesem Verein gibt es schon eine Mannschaft mit dieser Nummer');
            Valid := False;
            break;
          end;
        end;
      end;

      if Valid then
      begin

        if TeamName <> OrgTeamNode.GetAsString(aTeamName) then
        begin
          if TeamName = OrgTeamNode.GetAsString(aOrgTeamName) then
          begin
            // Der Name wurd wieder in den ursprnglichen umbenannt
            OrgTeamNode.SetAsString(aOrgTeamName, '');
          end
          else
          if '' <> OrgTeamNode.GetAsString(aOrgTeamName) then
          begin
            // Der ursprngliche Name ist schon gesetzt
          end
          else
          begin
            OrgTeamNode.SetAsString(aOrgTeamName, OrgTeamNode.GetAsString(aTeamName));
          end;
        end;

        OrgTeamNode.SetAsString(aTeamName, TeamName);
        OrgTeamNode.SetAsString(aTeamId, TeamId);
        OrgTeamNode.SetAsString(aClubID, ClubId);
        OrgTeamNode.SetAsString(aLocation, DefaultLocation);
        OrgTeamNode.SetAsInt(aTeamNumber, TeamNumber);
        DataToForm();
        FireOnChange();
        break;
      end;

    end;

    Dialog.Free;
  end;
end;



procedure TDialogPanelTeams.ButtonTeamNewClick(Sender: TObject);
var
  TeamName, TeamId, ClubId, DefaultLocation: String;
  TeamNumber: integer;
  DialogResult: integer;
  Dialog: TFormEditTeamName;
  TeamNode: TDataObject;
  Valid: boolean;
begin
  Dialog := TFormEditTeamName.Create(Self);
  while True do
  begin
    DialogResult := Dialog.ShowModal;

    if DialogResult = mrCancel then
    begin
      break;
    end;

    Dialog.GetValues(TeamName, TeamNumber, TeamId, ClubId, DefaultLocation);

    Valid := true;

    for TeamNode in PlanData.root.NamedChilds(nTeam) do
    begin
      if TeamName = TeamNode.GetAsString(aTeamName) then
      begin
        ShowMessage('Mannschaftsname ist nicht eindeutig');
        Valid := False;
        break;
      end;
      if TeamName = TeamNode.GetAsString(aTeamId) then
      begin
        ShowMessage('Mannschafts-ID ist nicht eindeutig');
        Valid := False;
        break;
      end;
      if (TeamNumber = TeamNode.GetAsInt(aTeamNumber)) and (ClubId = TeamNode.GetAsString(aClubID)) then
      begin
        ShowMessage('Zu diesem Verein gibt es schon eine Mannschaft mit dieser Nummer');
        Valid := False;
        break;
      end;
    end;

    if Valid then
    begin
      TeamNode := TDataObject.Create(nTeam, PlanData.root);
      TeamNode.SetAsString(aTeamName, TeamName);
      TeamNode.SetAsString(aTeamId, TeamId);
      TeamNode.SetAsString(aClubID, ClubId);
      TeamNode.SetAsString(aLocation, DefaultLocation);
      TeamNode.SetAsInt(aTeamNumber, TeamNumber);
      DataToForm();
      FireOnChange();
      break;
    end;

  end;

  Dialog.Free;
end;

procedure TDialogPanelTeams.ControlChange(Sender: TObject);
begin
  FireOnChange();
end;

procedure TDialogPanelTeams.FormCreate(Sender: TObject);
begin
  FixControls(Self);
end;

procedure TDialogPanelTeams.FormToData;
begin
end;

function TDialogPanelTeams.isDefault: boolean;
  function IsTheSame(TeamNode1, TeamNode2: TDataObject): boolean;
  begin
    Result := (TeamNode1.GetAsString(aTeamName) = TeamNode2.GetAsString(aTeamName))
              and (TeamNode1.GetAsString(aTeamId) = TeamNode2.GetAsString(aTeamId))
              and (TeamNode1.GetAsString(aLocation) = TeamNode2.GetAsString(aLocation))
              and (TeamNode1.GetAsString(aClubID) = TeamNode2.GetAsString(aClubID))
              and (TeamNode1.GetAsInt(aTeamNumber) = TeamNode2.GetAsInt(aTeamNumber));
  end;
var
  TeamNode1, TeamNode2: TDataObject;
begin
  Result := true;

  for TeamNode1 in PlanData.root.NamedChilds(nTeam) do
  begin
    Result := False;
    for TeamNode2 in PlanDataDefault.root.NamedChilds(nTeam) do
    begin
      if IsTheSame(TeamNode1, TeamNode2) then
      begin
        Result := True;
      end;
    end;

    if not Result then
    begin
      Exit;
    end;
  end;

  for TeamNode1 in PlanDataDefault.root.NamedChilds(nTeam) do
  begin
    Result := False;
    for TeamNode2 in PlanData.root.NamedChilds(nTeam) do
    begin
      if IsTheSame(TeamNode1, TeamNode2) then
      begin
        Result := True;
      end;
    end;
    if not Result then
    begin
      Exit;
    end;
  end;

end;

procedure TDialogPanelTeams.ListBoxTeamsClick(Sender: TObject);
begin
  EnableButtons();
end;

procedure TDialogPanelTeams.ListBoxTeamsDblClick(Sender: TObject);
begin
  ButtonTeamEditClick(nil);
end;

procedure TDialogPanelTeams.setPanel(PanelMain: TPanel);
begin
  Self.PanelMain.Parent := PanelMain;
end;

procedure TDialogPanelTeams.toDefault;
  function IsTheSameTeam(TeamNodePlan, TeamNodeDefault: TDataObject): boolean;
  begin
    Result := False;
    if '' <> TeamNodePlan.GetAsString(aOrgTeamName) then
    begin
      if TeamNodePlan.GetAsString(aOrgTeamName) = TeamNodeDefault.GetAsString(aTeamName) then
      begin
        Result := True;
      end;
    end
    else
    begin
      if TeamNodePlan.GetAsString(aTeamName) = TeamNodeDefault.GetAsString(aTeamName) then
      begin
        Result := True;
      end;
    end;
  end;

var
  TeamNode1, TeamNode2, TeamNode, NewTeamNode: TDataObject;
  TeamList: TList<TDataObject>;
  Found: boolean;
begin
  TeamList := TList<TDataObject>.Create;
  for TeamNode2 in PlanDataDefault.root.NamedChilds(nTeam) do
  begin
    Found := False;
    for TeamNode1 in PlanData.root.NamedChilds(nTeam) do
    begin
      if IsTheSameTeam(TeamNode1, TeamNode2) then
      begin
        Found := true;
      end;
    end;
    if not Found then
    begin
      TeamList.Add(TeamNode2);
    end;
  end;


  // Diese wurden gelscht, wieder einsetzen
  for TeamNode in TeamList do
  begin
    NewTeamNode := TDataObject.Create(nTeam, PlanData.root);
    NewTeamNode.assign(TeamNode);
  end;

  TeamList.Clear;

  for TeamNode1 in PlanData.root.NamedChilds(nTeam) do
  begin
    Found := False;
    for TeamNode2 in PlanDataDefault.root.NamedChilds(nTeam) do
    begin
      if IsTheSameTeam(TeamNode1, TeamNode2) then
      begin
        Found := True;
      end;
    end;

    if not Found then
    begin
      TeamList.Add(TeamNode1);
    end;
  end;

  // Diese wurden hinzugefgt, wieder lschen
  for TeamNode in TeamList do
  begin
    PlanData.root.RemoveChild(TeamNode);
  end;

  TeamList.Clear;

  // Attribute kopieren
  for TeamNode1 in PlanData.root.NamedChilds(nTeam) do
  begin
    for TeamNode2 in PlanDataDefault.root.NamedChilds(nTeam) do
    begin
      if IsTheSameTeam(TeamNode1, TeamNode2) then
      begin
        TeamNode1.assignAttributes(TeamNode2);
      end;
    end;
  end;

  DataToForm();

  TeamList.Free;

  FireOnChange();

end;

end.
