unit DialogPanelSisterTeamsDetail;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, EditMandatoryDatesDialog, Vcl.Menus, DialogPanelOptionArray, DialogForSingleGewichtungsOptions,
  DialogPanel, PlanDataObjects, DialogEditSisterTeam, System.UITypes, DialogTeamPanel;

type
  TDialogPanelSisterTeamsDetail = class(TDialogTeamPanel)
    PanelMain: TPanel;
    ButtonTeamDelete: TButton;
    ButtonTeamEdit: TButton;
    ButtonTeamNew: TButton;
    ListBoxTeams: TListBox;
    Panel1: TPanel;
    Panel2: TPanel;
    Label2: TLabel;
    procedure ControlChange(Sender: TObject);
    procedure ButtonTeamEditClick(Sender: TObject);
    procedure ButtonTeamDeleteClick(Sender: TObject);
    procedure ListBoxTeamsClick(Sender: TObject);
    procedure ButtonTeamNewClick(Sender: TObject);
    procedure ListBoxTeamsDblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    procedure EnableButtons();
    function getMainNode(PlanData: TPlanData): TDataObject;
    function getSelectedNode: TDataObject;
    function SisterTeamNodeToString(Node: TDataObject): String;

  public
    procedure setPanel(PanelMain: TPanel); override;
    procedure DataToForm(); override;
    procedure FormToData(); override;
    procedure toDefault(); override;
    function  isDefault(): boolean; override;
  end;


implementation

{$R *.dfm}



{ TDialogPanelFreeDays }

function TDialogPanelSisterTeamsDetail.SisterTeamNodeToString(Node: TDataObject): String;
var
  NumberOfGames: integer;
  Dummy: TDataObject;
begin
  NumberOfGames := 0;

  for Dummy in Node.NamedChilds(nSisterGame) do
  begin
    // Assigned ist eigentlich Quatsch, nur um die Warnung nicht zu bekommen
    if Assigned(Dummy) then
    begin
      Inc(NumberOfGames);
    end;
  end;
  Result := '(' + Node.GetAsString(aGender) + ') ' + Node.GetAsString(aTeamName) + ' ' + IntToStr(NumberOfGames) + ', Spiele';

  if Node.GetAsString(aLocation) <> '' then
  begin
    Result := Result + ', Spiellokal: ' + Node.GetAsString(aLocation);
  end;

  if Node.GetAsBool(aNoParallelGames) then
  begin
    Result := Result + ', gleichzeitige Spiele vermeiden';
  end;

  if Node.GetAsBool(aParallelHomeGames) then
  begin
    Result := Result + ', gleichzeitige Heimspiele erwnscht';
  end;

end;

procedure TDialogPanelSisterTeamsDetail.DataToForm;
var
  Names: TStringList;
  SisterTeamNode, TeamNode: TDataObject;
  OldIndex: integer;
begin
  OldIndex := ListBoxTeams.ItemIndex;

  Names := TStringList.Create;

  TeamNode := getMainNode(PlanData);

  if Assigned(TeamNode) then
  begin
    for SisterTeamNode in TeamNode.NamedChilds(nSisterTeam) do
    begin
      Names.Add(SisterTeamNodeToString(SisterTeamNode));
    end;
  end;

  Names.Sort;
  ListBoxTeams.Items := Names;
  Names.Free;

  if (OldIndex >= 0) and (OldIndex < ListBoxTeams.Items.Count) then
  begin
    ListBoxTeams.ItemIndex := OldIndex;
  end;


  EnableButtons();
end;


procedure TDialogPanelSisterTeamsDetail.EnableButtons;
begin
  ButtonTeamDelete.Enabled := Assigned(getSelectedNode());
  ButtonTeamEdit.Enabled := ButtonTeamDelete.Enabled;
end;

procedure TDialogPanelSisterTeamsDetail.ButtonTeamDeleteClick(Sender: TObject);
var
  TeamNode: TDataObject;
begin
  TeamNode := getSelectedNode();
  if Assigned(TeamNode) then
  begin
    if mrYes = MessageDlg('Mchten Sie die Mannschaft ' + TeamNode.GetAsString(aTeamName) + ' wirklich lschen?', mtConfirmation, [mbYes, mbNo], 0) then
    begin
      TeamNode.parent.RemoveChild(TeamNode);
      DataToForm();
      FireOnChange();
    end;
  end;
end;

procedure TDialogPanelSisterTeamsDetail.ButtonTeamEditClick(Sender: TObject);
var
  Dialog: TDialogEditSisterTeam;
begin
  if Assigned(getSelectedNode())  then
  begin
    Dialog := TDialogEditSisterTeam.Create(Self);
    Dialog.SetValues(getSelectedNode, PlanData, TeamName);
    if mrOK = Dialog.ShowModal then
    begin
      Dialog.GetValues(getSelectedNode);
      DataToForm();
      FireOnChange();
    end;
    Dialog.Free;
  end;
end;




procedure TDialogPanelSisterTeamsDetail.ButtonTeamNewClick(Sender: TObject);
var
  Dialog: TDialogEditSisterTeam;
  SisterNode: TDataObject;
begin
  Dialog := TDialogEditSisterTeam.Create(Self);
  Dialog.SetValues(nil, PlanData, TeamName);
  if mrOK = Dialog.ShowModal then
  begin
    SisterNode := TDataObject.Create(nSisterTeam, getMainNode(PlanData));
    Dialog.GetValues(SisterNode);
    DataToForm();
    FireOnChange();
  end;
  Dialog.Free;
end;

procedure TDialogPanelSisterTeamsDetail.ControlChange(Sender: TObject);
begin
  FireOnChange();
end;

procedure TDialogPanelSisterTeamsDetail.FormCreate(Sender: TObject);
begin
  FixControls(Self);
end;

procedure TDialogPanelSisterTeamsDetail.FormToData;
begin
end;

function TDialogPanelSisterTeamsDetail.getMainNode(PlanData: TPlanData): TDataObject;
var
  DataKey: TDataObjectKey;
  Index: integer;
begin
  Result := nil;
  DataKey := TDataObjectKey.Create;
  DataKey.Name := nTeam;
  DataKey.setAttribute(aTeamName, TeamName);
  Index := PlanData.root.findChildIndexByKey(DataKey);

  if Index >= 0  then
  begin
    Result := PlanData.root.childs[Index];
  end;

  DataKey.Free;
end;


function TDialogPanelSisterTeamsDetail.getSelectedNode: TDataObject;
var
  MainNode, TeamNode: TDataObject;
  TeamName: String;
begin
  Result := nil;

  if ListBoxTeams.ItemIndex >= 0 then
  begin
    TeamName := ListBoxTeams.Items[ListBoxTeams.ItemIndex];
    MainNode := getMainNode(PlanData);

    if Assigned(MainNode) then
    begin
      for TeamNode in MainNode.NamedChilds(nSisterTeam) do
      begin
        if TeamName = SisterTeamNodeToString(TeamNode) then
        begin
          Result := TeamNode;
        end;
      end;
    end;
  end;
end;

function TDialogPanelSisterTeamsDetail.isDefault: boolean;
var
  Node1, Node2: TDataObject;
begin
  Node1 := getMainNode(PlanData);
  Node2 := getMainNode(PlanDataDefault);

  Result := TDataObject.ChildNodesAreTheSame(Node1, Node2, nSisterTeam);
end;

procedure TDialogPanelSisterTeamsDetail.ListBoxTeamsClick(Sender: TObject);
begin
  EnableButtons();
end;

procedure TDialogPanelSisterTeamsDetail.ListBoxTeamsDblClick(Sender: TObject);
begin
  ButtonTeamEditClick(nil);
end;

procedure TDialogPanelSisterTeamsDetail.setPanel(PanelMain: TPanel);
begin
  Self.PanelMain.Parent := PanelMain;
end;

procedure TDialogPanelSisterTeamsDetail.toDefault;
var
  Node1, Node2, Node, NewNode: TDataObject;

begin
  Node1 := getMainNode(PlanData);
  Node2 := getMainNode(PlanDataDefault);

  while True do
  begin
    Node := Node1.FindChild(nSisterTeam);
    if Assigned(Node) then
    begin
      Node1.RemoveChild(Node);
    end
    else
    begin
      break;
    end;
  end;

  if Assigned(Node2) then
  begin
    for node in Node2.NamedChilds(nSisterTeam) do
    begin
      NewNode := TDataObject.Create(nSisterTeam, Node1);
      NewNode.assign(node);
    end;
  end;

  DataToForm;
  FireOnChange;
end;

end.
