unit DialogPanelRanking;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics, System.Types,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, Vcl.Menus, DialogPanel, PlanDataObjects;

type

  TDialogPanelRanking = class(TDialogPanel)
    PanelMain: TPanel;
    CheckBoxActive: TCheckBox;
    Label1: TLabel;
    Label2: TLabel;
    ListRanking: TListBox;
    ButtonUp: TButton;
    ButtonDown: TButton;
    procedure ListRankingDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure ListRankingDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure CheckBoxActiveClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ListRankingClick(Sender: TObject);
    procedure ButtonUpClick(Sender: TObject);
    procedure ButtonDownClick(Sender: TObject);
  private
    procedure EnableButtons();
  public
    procedure setPanel(PanelMain: TPanel); override;
    procedure DataToForm(); override;
    procedure FormToData(); override;
    procedure toDefault(); override;
    function  isDefault(): boolean; override;

  end;


implementation

{$R *.dfm}


{ TDialogPanelRanking }


procedure TDialogPanelRanking.ButtonDownClick(Sender: TObject);
begin
  if ListRanking.ItemIndex < ListRanking.Items.Count - 1 then
  begin
    ListRanking.Items.Exchange(ListRanking.ItemIndex, ListRanking.ItemIndex+1);
  end;
  EnableButtons();
end;

procedure TDialogPanelRanking.ButtonUpClick(Sender: TObject);
begin
  if ListRanking.ItemIndex > 0 then
  begin
    ListRanking.Items.Exchange(ListRanking.ItemIndex, ListRanking.ItemIndex-1);
  end;
  EnableButtons();
end;

procedure TDialogPanelRanking.CheckBoxActiveClick(Sender: TObject);
begin
  FireOnChange();
end;

procedure TDialogPanelRanking.DataToForm;
var
  TeamName: String;
  Mannschaften: TStrings;
  found: boolean;
  RankingNode: TDataObject;
  TeamNode: TDataObject;
  RankingIndex: integer;
  i: integer;
begin
  RankingNode := PlanData.root.FindChild(nRanking);

  Mannschaften := TStringList.Create;

  PlanData.getTeamNames(Mannschaften);

  ListRanking.Items.Clear;
  if Assigned(RankingNode) then
  begin
    CheckBoxActive.Checked := RankingNode.GetAsBool(aActive);

    for TeamNode in RankingNode.NamedChilds(nTeam) do
    begin

      TeamName := TeamNode.GetAsString(aTeamName);

      if Mannschaften.IndexOf(TeamName) >= 0 then
      begin
        RankingIndex := TeamNode.GetAsInt(aRankingIndex);

        while ListRanking.Items.Count <= RankingIndex do
        begin
          ListRanking.Items.Add(TeamName);
        end;
      end;
    end;

    for i := ListRanking.Items.Count-1 downto 0 do
    begin
      if '' = ListRanking.Items[i] then
      begin
        ListRanking.Items.Delete(i);
      end;
    end;
  end;

  for TeamName in Mannschaften do
  begin
    found := False;
    for i := 0 to ListRanking.Items.Count-1 do
    begin
      if teamName = ListRanking.Items[i] then
        found := true;
    end;

    if not found then
    begin
      ListRanking.Items.Add(TeamName);
    end;
  end;

  if ListRanking.Items.Count > 0 then
  begin
    ListRanking.ItemIndex := 0;
  end;

  Mannschaften.Free;

  EnableButtons();

end;

procedure TDialogPanelRanking.EnableButtons;
begin
  ButtonUp.Enabled := False;
  ButtonDown.Enabled := False;

  if ListRanking.ItemIndex > 0 then
  begin
    ButtonUp.Enabled := True;
  end;

  if (ListRanking.ItemIndex >= 0) and (ListRanking.ItemIndex < ListRanking.Items.Count - 1)then
  begin
    ButtonDown.Enabled := True;
  end;

end;

procedure TDialogPanelRanking.FormCreate(Sender: TObject);
begin
  FixControls(Self);
end;

procedure TDialogPanelRanking.FormToData;
var
  i: integer;
  RankingNode, TeamNode: TDataObject;
begin
  RankingNode := PlanData.root.getOrCreateChild(nRanking);
  RankingNode.clear();
  RankingNode.SetAsBool(aActive, CheckBoxActive.Checked);

  for i := 0 to ListRanking.Items.Count-1 do
  begin
    TeamNode := TDataObject.Create(nTeam, RankingNode);
    TeamNode.SetAsString(aTeamName, ListRanking.Items[i]);
    TeamNode.SetAsInt(aRankingIndex, i);
  end;
end;

function TDialogPanelRanking.isDefault: boolean;
begin
  Result := not CheckBoxActive.Checked;
end;

procedure TDialogPanelRanking.ListRankingClick(Sender: TObject);
begin
  EnableButtons();
end;

procedure TDialogPanelRanking.ListRankingDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var
  DropIndex, CurrentIndex: integer;
  S: String;
begin
  if Sender = Source then
  begin
    with TListBox(Sender) do
    begin
      if ItemIndex >= 0 then
      begin
        DropIndex    := ItemAtPos(Point(X, Y), true);
        CurrentIndex := ItemIndex;

        S := Items[CurrentIndex];

        if DropIndex > CurrentIndex then
        begin
          Dec(DropIndex);
        end;

        Items.Delete(CurrentIndex);

        Items.Insert(DropIndex, S);

        ItemIndex := DropIndex;
      end;
    end;
  end;
  EnableButtons();
end;


procedure TDialogPanelRanking.ListRankingDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept := Sender = ListRanking;
end;

procedure TDialogPanelRanking.setPanel(PanelMain: TPanel);
begin
  Self.PanelMain.Parent := PanelMain;
end;

procedure TDialogPanelRanking.toDefault;
begin
  CheckBoxActive.Checked := false;
  FireOnChange;
end;

end.
