unit DialogPanelPredefinedGames;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, EditMandatoryDatesDialog, Vcl.Menus, DialogPanelOptionArray, DialogForSingleGewichtungsOptions,
  DialogPanel, PlanDataObjects, DialogEditTeamName, System.UITypes, Math, DialogEditOneGame;

type
  TDialogPanelPredefinedGames = class(TDialogPanel)
    PanelMain: TPanel;
    PanelClient: TPanel;
    ButtonGameDelete: TButton;
    ButtonGameEdit: TButton;
    ButtonGameNew: TButton;
    Label1: TLabel;
    PanelTop: TPanel;
    PanelRight: TPanel;
    Grid: TStringGrid;
    procedure ControlChange(Sender: TObject);
    procedure ButtonGameEditClick(Sender: TObject);
    procedure ButtonGameDeleteClick(Sender: TObject);
    procedure ListBoxTeamsClick(Sender: TObject);
    procedure ButtonGameNewClick(Sender: TObject);
    procedure GridClick(Sender: TObject);
    procedure GridDblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    procedure EnableButtons();
    procedure SortGrid;
    function getMainNode: TDataObject;
    function getOrCreateMainNode: TDataObject;
    function getSelectedGameNode: TDataObject;
  public
    procedure setPanel(PanelMain: TPanel); override;
    procedure DataToForm(); override;
    procedure FormToData(); override;
    procedure toDefault(); override;
    function  isDefault(): boolean; override;

  end;


implementation

{$R *.dfm}



{ TDialogPanelFreeDays }

procedure TDialogPanelPredefinedGames.SortGrid();
var
  row: Integer;
  Date1, Date2: TDateTime;
  col: Integer;
  S: String;
begin
  row := 1;
  while row <= grid.RowCount-2 do
  begin
    Date1 := DateFromString(Grid.Cells[0, row]) + TimeFromString(Grid.Cells[1, row]);
    Date2 := DateFromString(Grid.Cells[0, row+1]) + TimeFromString(Grid.Cells[1, row+1]);

    if Date1 > Date2 then
    begin
      for col := 0 to grid.ColCount-1 do
      begin
        S := Grid.Cells[col, row];
        Grid.Cells[col, row] := Grid.Cells[col, row+1];
        Grid.Cells[col, row+1] := S;
      end;
      row := 1;
    end
    else
    begin
      Inc(row);
    end;
  end;
end;

procedure TDialogPanelPredefinedGames.DataToForm;
var
  GameNode, predefinedGameNode: TDataObject;
  col: Integer;
  row: integer;
  OldRow: integer;
  GameDate: TDateTime;
begin
  OldRow := Grid.Row;
  Grid.RowCount := 2;
  Grid.Cells[0, 0] := 'Datum';
  Grid.Cells[1, 0] := 'Uhrzeit';
  Grid.Cells[2, 0] := 'Heimmannschaft';
  Grid.Cells[3, 0] := 'Gastmannschaft';
  Grid.Cells[4, 0] := 'Spiellokal';

  Grid.ColWidths[0] := 100;
  Grid.ColWidths[1] := 80;
  Grid.ColWidths[2] := 200;
  Grid.ColWidths[3] := 200;
  Grid.ColWidths[4] := 200;

  for col := 0 to Grid.ColCount-1 do
  begin
    Grid.Cells[col, 1] := '';
  end;

  row := 1;

  predefinedGameNode := PlanData.root.FindChild(nPredefinedGames);

  if Assigned(predefinedGameNode) then
  begin
    for GameNode in predefinedGameNode.NamedChilds(nGame) do
    begin
      Grid.RowCount := max(2, row + 1);

      GameDate := GameNode.GetAsDateTime(aDateTime);

      Grid.Cells[0, row] := DateToString(Trunc(GameDate));
      Grid.Cells[1, row] := TimeToString(FixDateTime(GameDate - Trunc(GameDate)));
      Grid.Cells[2, row] := GameNode.GetAsString(aHomeTeamName);
      Grid.Cells[3, row] := GameNode.GetAsString(aGuestTeamName);
      Grid.Cells[4, row] := PlanData.FixLocation(GameNode.GetAsString(aLocation));

      Inc(row);
    end;
  end;
  SortGrid();

  if OldRow > 0 then
  begin
    Grid.Row := OldRow;
  end;
  EnableButtons();
end;


procedure TDialogPanelPredefinedGames.EnableButtons;
var
  ValidLine: boolean;
begin
  ValidLine := Grid.Row > 0;
  if ValidLine then
  begin
    ValidLine := Trim(Grid.Cells[0, Grid.Row]) <> '';
  end;

  ButtonGameDelete.Enabled := ValidLine;
  ButtonGameEdit.Enabled := ValidLine;
end;

function TDialogPanelPredefinedGames.getMainNode(): TDataObject;
begin
  Result := PlanData.root.FindChild(nPredefinedGames);
end;

function TDialogPanelPredefinedGames.getOrCreateMainNode: TDataObject;
begin
  Result := getMainNode();

  if not Assigned(Result) then
  begin
    Result := TDataObject.Create(nPredefinedGames, PlanData.root);
  end;
end;

function TDialogPanelPredefinedGames.getSelectedGameNode(): TDataObject;
var
  MainNode: TDataObject;
  GameNode: TDataObject;
  GameDate: TDateTime;
begin
  Result := nil;
  MainNode := getMainNode();

  if Assigned(MainNode) then
  begin
    if Grid.Row > 0 then
    begin
      for GameNode in MainNode.NamedChilds(nGame) do
      begin
        GameDate := GameNode.GetAsDateTime(aDateTime);
        if (Grid.Cells[0, Grid.row] = DateToString(Trunc(GameDate)))
            and (Grid.Cells[1, Grid.row] = TimeToString(FixDateTime(GameDate - Trunc(GameDate))))
            and (Grid.Cells[2, Grid.row] = GameNode.GetAsString(aHomeTeamName))
            and (Grid.Cells[3, Grid.row] = GameNode.GetAsString(aGuestTeamName)) then
        begin
          Result := GameNode;
        end;
      end;
    end;
  end;
end;


procedure TDialogPanelPredefinedGames.ButtonGameDeleteClick(Sender: TObject);
var
  MainNode: TDataObject;
  GameNode: TDataObject;
begin
  MainNode := getMainNode();
  GameNode := getSelectedGameNode();

  if Assigned(GameNode) then
  begin
    if mrYes = MessageDlg('Mchten Sie das Spiel wirklich lschen?', mtConfirmation, [mbYes, mbNo], 0) then
    begin
      MainNode.RemoveChild(GameNode);
      DataToForm();
      FireOnChange;
    end;
  end;
end;

procedure TDialogPanelPredefinedGames.ButtonGameEditClick(Sender: TObject);
var
  Dialog: TDialogEditOneGame;
  GameNode: TDataObject;
begin
  GameNode := getSelectedGameNode();

  if Assigned(GameNode) then
  begin
    Dialog := TDialogEditOneGame.Create(Self);
    Dialog.SetValue(PlanData, GameNode);

    if mrOk = Dialog.ShowModal then
    begin
      Dialog.GetValue(GameNode);
      DataToForm;
      FireOnChange;
    end;
    Dialog.Free;
  end;
end;



procedure TDialogPanelPredefinedGames.ButtonGameNewClick(Sender: TObject);
var
  Dialog: TDialogEditOneGame;
  MainNode, GameNode: TDataObject;
begin
  Dialog := TDialogEditOneGame.Create(Self);
  Dialog.SetValue(PlanData, nil);

  if mrOk = Dialog.ShowModal then
  begin
    MainNode := getOrCreateMainNode();
    GameNode := TDataObject.Create(nGame, MainNode);
    Dialog.GetValue(GameNode);
    DataToForm;
    FireOnChange;
  end;

  Dialog.Free;
end;

procedure TDialogPanelPredefinedGames.ControlChange(Sender: TObject);
begin
  FireOnChange();
end;

procedure TDialogPanelPredefinedGames.FormCreate(Sender: TObject);
begin
  FixControls(Self);
end;

procedure TDialogPanelPredefinedGames.FormToData;
begin
end;

procedure TDialogPanelPredefinedGames.GridClick(Sender: TObject);
begin
  EnableButtons();
end;

procedure TDialogPanelPredefinedGames.GridDblClick(Sender: TObject);
begin
  if Assigned(getSelectedGameNode()) then
  begin
    ButtonGameEditClick(nil);
  end;
end;

function TDialogPanelPredefinedGames.isDefault: boolean;
var
  Node1, Node2: TDataObject;
begin

  Node1 := PlanData.root.FindChild(nPredefinedGames);
  Node2 := PlanDataDefault.root.FindChild(nPredefinedGames);

  Result := TDataObject.NodesAreTheSame(Node1, Node2);
end;

procedure TDialogPanelPredefinedGames.ListBoxTeamsClick(Sender: TObject);
begin
  EnableButtons();
end;

procedure TDialogPanelPredefinedGames.setPanel(PanelMain: TPanel);
begin
  Self.PanelMain.Parent := PanelMain;
end;

procedure TDialogPanelPredefinedGames.toDefault;
var
  Node1, Node2: TDataObject;
begin

  Node1 := PlanData.root.FindChild(nPredefinedGames);
  Node2 := PlanDataDefault.root.FindChild(nPredefinedGames);

  if (Node2 = nil) then
  begin
    if Assigned(Node1) then
    begin
      PlanData.root.RemoveChild(Node1);
    end;
  end
  else
  begin
    if Node1 = nil then
    begin
      Node1 := TDataObject.Create(nPredefinedGames, PlanData.root);
    end;

    Node1.assign(Node2);
  end;

  DataToForm;
  FireOnChange;
end;

end.
