unit DialogPanelOptionArray;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, EditMandatoryDatesDialog, Vcl.Menus;

type
  TOptionButtonClick = procedure(Sender: TObject; Index: integer) of object;

  TFormPanelOptionArray = class(TForm)
    PanelMain: TScrollBox;
    ComboPositionHelperSecond: TComboBox;
    LabelPositionHelperSecond: TLabel;
    ComboPositionHelperFirst: TComboBox;
    LabelPositionHelperFirst: TLabel;
    ButtonPositionHelper: TButton;
    procedure FormCreate(Sender: TObject);
    procedure ControlChanged(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private-Deklarationen }
    Combos: TList<TComboBox>;
    Labels: TList<TLabel>;
    Buttons: TList<TButton>;
    VisibleState: TList<boolean>;
    FOnChanged: TNotifyEvent;
    InLoad: boolean;
    FShowButtons: boolean;
    FOnButtonClick: TOptionButtonClick;
    procedure FillCombo(Combo: TComboBox);
    procedure ReArangeCombos();
    procedure SetShowButtons(const Value: boolean);
    procedure ButtonClick(Sender: TObject);
  public
    { Public-Deklarationen }
    procedure Init(titles: TStrings);
    procedure SetValues(values: TList<TCalculateOptionsValues>);
    procedure SetVisibleState(values: TList<boolean>);
    procedure GetValues(values: TList<TCalculateOptionsValues>);
    procedure SetPanel(ParentPanel: TWinControl);
    procedure toDefault();
    function  isDefault(): boolean;
    property  ShowButtons: boolean read FShowButtons write SetShowButtons;
    property OnChanged: TNotifyEvent read FOnChanged write FOnChanged;
    property OnButtonClick: TOptionButtonClick read FOnButtonClick write FOnButtonClick;
  end;


implementation

{$R *.dfm}


procedure TFormPanelOptionArray.ButtonClick(Sender: TObject);
var
  Index: integer;
begin
  if Assigned(FOnButtonClick) then
  begin
    if Sender is TButton then
    begin
      Index := Buttons.IndexOf(Sender as TButton);
      if Index >= 0 then
      begin
        FOnButtonClick(Sender, Index);
      end;
    end;
  end;
end;


procedure TFormPanelOptionArray.ControlChanged(Sender: TObject);
begin
  if not InLoad then
  begin
    if Assigned(FOnChanged) then
    begin
      FOnChanged(Self);
    end;
  end;
end;


procedure TFormPanelOptionArray.FillCombo(Combo: TComboBox);
var
  i: TCalculateOptionsValues;
begin
  for i := Low(TCalculateOptionsValues) to High(TCalculateOptionsValues) do
  begin
    Combo.Items.Add(cCalculateOptionsNamen[i]);
  end;
  Combo.ItemIndex := 3;
end;

procedure TFormPanelOptionArray.FormCreate(Sender: TObject);
begin

  InLoad := False;

  Combos := TList<TComboBox>.Create;
  Labels := TList<TLabel>.Create;
  Buttons := TList<TButton>.Create;
  VisibleState := TList<boolean>.Create;

  FixControls(Self);
end;


procedure TFormPanelOptionArray.Init(titles: TStrings);
var
  NewLabel: TLabel;
  NewCombo: TComboBox;
  NewButton: TButton;
  S: String;
begin

  for S in titles do
  begin
    NewLabel := TLabel.Create(Self);
    NewLabel.Parent := PanelMain;
    NewLabel.Top := 0;
    NewLabel.Left := LabelPositionHelperFirst.Left;
    NewLabel.Height := LabelPositionHelperFirst.Height;
    NewLabel.Width := LabelPositionHelperFirst.Width;
    NewLabel.Caption := S;

    Labels.Add(NewLabel);

    NewCombo := TComboBox.Create(Self);
    NewCombo.Parent := PanelMain;
    NewCombo.Top := 0;
    NewCombo.Left := ComboPositionHelperFirst.Left;
    NewCombo.Height := ComboPositionHelperFirst.Height;
    NewCombo.Width := ComboPositionHelperFirst.Width;
    NewCombo.Style := csDropDownList;
    NewCombo.OnClick := ControlChanged;
    FillCombo(NewCombo);

    Combos.Add(NewCombo);


    NewButton := TButton.Create(Self);
    NewButton.Parent := PanelMain;
    NewButton.Top := 0;
    NewButton.Left := ButtonPositionHelper.Left;
    NewButton.Height := ButtonPositionHelper.Height;
    NewButton.Width := ButtonPositionHelper.Width;
    NewButton.Caption := ButtonPositionHelper.Caption;
    NewButton.OnClick := ButtonClick;

    Buttons.Add(NewButton);

    VisibleState.Add(true);
  end;

  ReArangeCombos();
end;



procedure TFormPanelOptionArray.FormDestroy(Sender: TObject);
begin
  Combos.Free;
  Labels.Free;
  Buttons.Free;
  VisibleState.Free;
end;


procedure TFormPanelOptionArray.ReArangeCombos();
var
  yPos: integer;
  i: Integer;
begin
  yPos := LabelPositionHelperFirst.Top;
  for i := 0 to Combos.Count-1 do
  begin
    if VisibleState[i] then
    begin
      Combos[i].top := ComboPositionHelperFirst.Top - LabelPositionHelperFirst.Top + yPos;
      Combos[i].Visible := true;

      Labels[i].top := yPos;
      Labels[i].Visible := true;

      if ShowButtons then
      begin
        Buttons[i].Visible := true;
        Buttons[i].top := ButtonPositionHelper.Top - LabelPositionHelperFirst.Top + yPos;
      end
      else
      begin
        Buttons[i].Visible := false;
      end;

      yPos := yPos + LabelPositionHelperSecond.Top - LabelPositionHelperFirst.Top;
    end
    else
    begin
      Combos[i].Visible := false;
      Labels[i].Visible := false;
      Buttons[i].Visible := false;
    end;
  end;
end;



procedure TFormPanelOptionArray.SetPanel(ParentPanel: TWinControl);
begin
  PanelMain.Parent := ParentPanel;
end;

procedure TFormPanelOptionArray.SetShowButtons(const Value: boolean);
begin
  FShowButtons := Value;
  ReArangeCombos();
end;

procedure TFormPanelOptionArray.SetValues(values: TList<TCalculateOptionsValues>);
var
  i: Integer;
begin
  InLoad := True;
  for i := 0 to values.Count-1 do
  begin
    Combos[i].ItemIndex := Ord(values[i]);
  end;
  InLoad := False;
end;

procedure TFormPanelOptionArray.SetVisibleState(values: TList<boolean>);
var
  i: integer;
  changed: boolean;
begin
  changed := false;
  for i := 0 to values.Count-1 do
  begin
    if VisibleState[i] <> values[i] then
    begin
      VisibleState[i] := values[i];
      changed := true;
    end;
  end;
  if changed then
  begin
    ReArangeCombos();
  end;
end;

procedure TFormPanelOptionArray.toDefault;
var
  Combo: TComboBox;
begin
  InLoad := true;
  for combo in Combos do
  begin
    Combo.ItemIndex := ord(coNormal);
  end;
  InLoad := False;
end;


function TFormPanelOptionArray.isDefault: boolean;
var
  Combo: TComboBox;
begin
  Result := True;
  for combo in Combos do
  begin
    if Combo.ItemIndex <> ord(coNormal) then
    begin
      Result := False;
    end;
  end;
end;


procedure TFormPanelOptionArray.GetValues(values: TList<TCalculateOptionsValues>);
var
  i: integer;
  val: TCalculateOptionsValues;
begin
  values.Clear;
  for i := 0 to Combos.Count-1 do
  begin
    val := TCalculateOptionsValues(Combos[i].ItemIndex);
    values.Add(val);
  end;
end;


end.
