unit DialogPanelMultiTeams;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, Vcl.Menus, DialogPanel, PlanDataObjects, DialogTeamPanel;

type
  TDialogPanelMultiTeams = class(TDialogPanel)
    PanelMain: TPanel;
    ScrollBoxMain: TPanel;
    PanelHeader: TPanel;
    PanelDetail: TPanel;
    PanelFixedHeaderText: TPanel;
    LabelHeaderText: TLabel;
    TreeView: TTreeView;
    procedure FormCreate(Sender: TObject);
    procedure TreeViewChange(Sender: TObject; Node: TTreeNode);
    procedure TreeViewChanging(Sender: TObject; Node: TTreeNode;
      var AllowChange: Boolean);
  private
    DialogPanel: TDialogTeamPanel;
    procedure ChangePanel(TeamName: String);
    procedure DoOnDialogDetailChanged(Sender: TObject);
  public
    function getDialogClass(): TDialogTeamPanelClass; virtual; abstract;
    function getCaption(): String; virtual; abstract;
    function getHeaderText(): String; virtual; abstract;
    procedure setPanel(PanelMain: TPanel); override;
    procedure DataToForm(); override;
    procedure FormToData(); override;
    procedure toDefault(); override;
    function  isDefault(): boolean; override;
    function  CheckData(): boolean; override;
  end;


implementation

{$R *.dfm}


var
  LastTeam: String;


{ TDialogPanelTeamAccordion }

function TDialogPanelMultiTeams.CheckData: boolean;
begin
  Result := True;
  if Assigned(DialogPanel) then
  begin
    Result := DialogPanel.CheckData;
  end;
end;

procedure TDialogPanelMultiTeams.DataToForm;
var
  TeamNamen: TStrings;
  S: String;
  isFirst: boolean;
  Node: TTreeNode;
  NodeToSelect: TTreeNode;
begin
  TreeView.Items.Clear;
  TeamNamen := TStringList.Create;
  PlanData.getTeamNames(TeamNamen);

  NodeToSelect := nil;

  isFirst := true;
  for S in TeamNamen do
  begin
    Node := TreeView.Items.AddChild(nil, S);

    if isFirst then
    begin
      NodeToSelect := Node;
      isFirst := False;
    end;

    if S = LastTeam then
    begin
      NodeToSelect := Node;
    end;

  end;

  if Assigned(NodeToSelect) then
  begin
    // ChangePanel wird ber Selected aufgerufen
    NodeToSelect.Selected := true;
  end;


  TeamNamen.Free;
end;

procedure TDialogPanelMultiTeams.DoOnDialogDetailChanged(Sender: TObject);
begin
  FireOnChange();
end;

procedure TDialogPanelMultiTeams.FormCreate(Sender: TObject);
begin
  Caption := getCaption();
  LabelHeaderText.Caption := getHeaderText();

  if LabelHeaderText.Caption = '' then
  begin
    PanelFixedHeaderText.Visible := False;
  end;

  FixControls(Self);
end;

procedure TDialogPanelMultiTeams.FormToData;
begin
  if Assigned(DialogPanel) then
  begin
    DialogPanel.FormToData;
  end;
end;


function TDialogPanelMultiTeams.isDefault: boolean;
begin
  Result := True;
  if Assigned(DialogPanel) then
  begin
    if not DialogPanel.isDefault then
    begin
      Result := False;
    end;
  end;
end;


procedure TDialogPanelMultiTeams.setPanel(PanelMain: TPanel);
begin
  Self.PanelMain.Parent := PanelMain;
end;

procedure TDialogPanelMultiTeams.toDefault;
begin
  if Assigned(DialogPanel) then
  begin
    DialogPanel.toDefault();
  end;
end;

procedure TDialogPanelMultiTeams.TreeViewChange(Sender: TObject; Node: TTreeNode);
begin
  if not (csDestroying in ComponentState) then
  begin
    if node.Selected then
    begin
      ChangePanel(node.Text);
    end;
  end;
end;

procedure TDialogPanelMultiTeams.TreeViewChanging(Sender: TObject;
  Node: TTreeNode; var AllowChange: Boolean);
begin
  AllowChange := True;
  if not (csDestroying in ComponentState) then
  begin
    if Assigned(DialogPanel) then
    begin
      if not DialogPanel.CheckData() then
      begin
        AllowChange := False;
      end;
    end;
  end;
end;

procedure TDialogPanelMultiTeams.ChangePanel(TeamName: String);
begin
  LastTeam := TeamName;
  if Assigned(DialogPanel) then
  begin
    DialogPanel.FormToData();
    FreeAndNil(DialogPanel);
  end;

  DialogPanel := getDialogClass.Create(Self);
  DialogPanel.setPanel(PanelDetail);
  DialogPanel.setPlanData(TeamName, PlanData, PlanDataDefault);
  DialogPanel.DataToForm();
  DialogPanel.OnChange := DoOnDialogDetailChanged;

  PanelHeader.Caption := TeamName + ' / ' + getCaption;

  ScrollBoxMain.Visible := true;

  FireOnChange;
end;


end.
