unit DialogPanelMandatoryDays;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, EditMandatoryDatesDialog, Vcl.Menus, DialogPanelOptionArray, DialogForSingleGewichtungsOptions,
  DialogPanel, PlanDataObjects;

type
  TDialogPanelMandatoryDays = class(TDialogPanel)
    PanelMain: TPanel;
    PanelMandatoryDatesMain: TPanel;
    Label2: TLabel;
    PanelMandatoryDatesTop: TPanel;
    ValueListMandatoryDates: TValueListEditor;
    PopupMenuMandatoryDays: TPopupMenu;
    Neu1: TMenuItem;
    PopupMenuBearbeiten: TMenuItem;
    PopupMenuDelete: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ListViewFreeDatesClick(Sender: TObject);
    procedure ValueListMandatoryDatesMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ValueListMandatoryDatesStringsChange(Sender: TObject);
    procedure Neu1Click(Sender: TObject);
    procedure PopupMenuBearbeitenClick(Sender: TObject);
    procedure PopupMenuDeleteClick(Sender: TObject);
  private
    DefaultMandatoryGameList: TPlanMandatoryTimeList;
    workMandatoryGameList: TPlanMandatoryTimeList;
    mapRowToMandatoryGameList: TDictionary<integer, TPlanMandatoryTime>;
    InLoad: boolean;
    procedure FormToDateList(ResultList: TPlanMandatoryTimeList);
    procedure DateListToForm(DateList: TPlanMandatoryTimeList);
    procedure DateListFromData(ResultList: TPlanMandatoryTimeList; PlanData: TPlanData);
  public
    procedure setPanel(PanelMain: TPanel); override;
    procedure DataToForm(); override;
    procedure FormToData(); override;
    procedure toDefault(); override;
    function  isDefault(): boolean; override;

  end;


implementation

{$R *.dfm}



{ TDialogPanelFreeDays }

procedure TDialogPanelMandatoryDays.DataToForm;
var
  DateList: TPlanMandatoryTimeList;
begin
  DateList := TPlanMandatoryTimeList.Create;
  DateListFromData(DateList, PlanData);
  DateListToForm(DateList);
  DateList.Free;
end;


procedure TDialogPanelMandatoryDays.DateListFromData(ResultList: TPlanMandatoryTimeList; PlanData: TPlanData);
var
  DayNode: TDataObject;
  Elem: TPlanMandatoryTime;
begin
  ResultList.Clear;

  for DayNode in PlanData.root.NamedChilds(nMandatoryGames) do
  begin
    Elem := TPlanMandatoryTime.Create;
    Elem.DateFrom := DayNode.GetAsDate(aDateFrom);
    Elem.DateTo := DayNode.GetAsDate(aDateTo);
    Elem.GameCount := DayNode.GetAsInt(aNumberGames);
    ResultList.Add(Elem);
  end;

  ResultList.Sort;
end;


procedure TDialogPanelMandatoryDays.DateListToForm(DateList: TPlanMandatoryTimeList);
var
  Elem: TPlanMandatoryTime;
  Row: integer;
  ItemProp: TItemProp;
  i: Integer;
begin
  InLoad := True;
  try
    ValueListMandatoryDates.Strings.Clear;
    workMandatoryGameList.Assign(DateList);
    mapRowToMandatoryGameList.Clear;

    for Elem in workMandatoryGameList do
    begin
      Row := ValueListMandatoryDates.InsertRow(MyFormatDate(Elem.DateFrom) + ' - ' + MyFormatDate(Elem.DateTo), IntToStr(Elem.GameCount), true);

      mapRowToMandatoryGameList.Add(Row, Elem);

      ItemProp := ValueListMandatoryDates.ItemProps[Row - 1];

      ItemProp.ReadOnly := True;
      ItemProp.EditStyle := esPickList;
      for i := 1 to 10 do
      begin
        ItemProp.PickList.Add(IntToStr(i));
      end;
    end;

    if ValueListMandatoryDates.Strings.Count = 0 then
    begin
      Row := ValueListMandatoryDates.InsertRow('Keine Pflichtspieltermine vorhanden', '', True);
      ItemProp := ValueListMandatoryDates.ItemProps[Row - 1];
      ItemProp.ReadOnly := True;
    end;
  finally
    InLoad := False;
  end;
end;


procedure TDialogPanelMandatoryDays.FormCreate(Sender: TObject);
begin
  ValueListMandatoryDates.DefaultRowHeight := MulDiv(ValueListMandatoryDates.DefaultRowHeight, Screen.PixelsPerInch, 96);
  DefaultMandatoryGameList := TPlanMandatoryTimeList.Create;
  workMandatoryGameList := TPlanMandatoryTimeList.Create;
  mapRowToMandatoryGameList := TDictionary<integer, TPlanMandatoryTime>.Create;

  FixControls(Self);
end;

procedure TDialogPanelMandatoryDays.FormDestroy(Sender: TObject);
begin
  DefaultMandatoryGameList.Free;
  workMandatoryGameList.Free;
  mapRowToMandatoryGameList.Free;
end;

procedure TDialogPanelMandatoryDays.FormToData;
var
  DateList: TPlanMandatoryTimeList;
  Date: TPlanMandatoryTime;
  NewElem: TDataObject;
begin
  PlanData.root.deleteChilds(nMandatoryGames);

  DateList := TPlanMandatoryTimeList.Create;
  FormToDateList(DateList);

  for Date in DateList do
  begin
    NewElem := TDataObject.Create(nMandatoryGames, PlanData.root);
    NewElem.SetAsDate(aDateFrom, Date.DateFrom);
    NewElem.SetAsDate(aDateTo, Date.DateTo);
    NewElem.SetAsInt(aNumberGames, Date.GameCount);
  end;
  DateList.Free;
end;


procedure TDialogPanelMandatoryDays.FormToDateList(ResultList: TPlanMandatoryTimeList);
var
  row: integer;
  S: String;
begin

  for row in mapRowToMandatoryGameList.Keys do
  begin
    S := ValueListMandatoryDates.Cells[1, row];
    mapRowToMandatoryGameList[row].GameCount := StrToInt(S);
  end;

  ResultList.Assign(workMandatoryGameList);
end;


function TDialogPanelMandatoryDays.isDefault: boolean;
var
  DateList1, DateList2: TPlanMandatoryTimeList;
  i: integer;
begin
  DateList1 := TPlanMandatoryTimeList.Create;
  DateList2 := TPlanMandatoryTimeList.Create;

  if Assigned(PlanDataDefault) then
  begin
    DateListFromData(DateList1, PlanDataDefault);
  end;

  FormToData();

  DateListFromData(DateList2, PlanData);

  Result := DateList1.Count = DateList2.Count;

  if Result then
  begin
    for i := 0 to DateList1.Count-1 do
    begin
      if not DateList1[i].IsTheSame(DateList2[i]) then
      begin
        Result := False;
      end;
    end;
  end;

  DateList1.Free;
  DateList2.Free;
end;

procedure TDialogPanelMandatoryDays.ListViewFreeDatesClick(Sender: TObject);
begin
  FireOnChange();
end;

procedure TDialogPanelMandatoryDays.Neu1Click(Sender: TObject);
var
  NewElem: TPlanMandatoryTime;
begin
  FormToDateList(workMandatoryGameList);
  NewElem := TPlanMandatoryTime.Create;
  NewElem.DateFrom := now;
  NewElem.DateTo := now;
  NewElem.GameCount := 1;
  if EditMandatoryDate(NewElem) then
  begin
    workMandatoryGameList.Add(NewElem);
    DateListToForm(workMandatoryGameList);
    FireOnChange();
  end
  else
  begin
    NewElem.Free;
  end;
end;

procedure TDialogPanelMandatoryDays.PopupMenuBearbeitenClick(Sender: TObject);
var
  Row: integer;
begin
  Row := ValueListMandatoryDates.Row;
  FormToDateList(workMandatoryGameList);
  if mapRowToMandatoryGameList.ContainsKey(Row) then
  begin
    if EditMandatoryDate(mapRowToMandatoryGameList[Row]) then
    begin
      DateListToForm(workMandatoryGameList);
      FireOnChange();
    end;
  end;
end;

procedure TDialogPanelMandatoryDays.PopupMenuDeleteClick(Sender: TObject);
var
  Row: integer;
begin
  Row := ValueListMandatoryDates.Row;
  FormToDateList(workMandatoryGameList);
  if mapRowToMandatoryGameList.ContainsKey(Row) then
  begin
    workMandatoryGameList.Remove(mapRowToMandatoryGameList[Row]);
    DateListToForm(workMandatoryGameList);
    FireOnChange();
  end;
end;


procedure TDialogPanelMandatoryDays.setPanel(PanelMain: TPanel);
begin
  Self.PanelMain.Parent := PanelMain;
end;

procedure TDialogPanelMandatoryDays.toDefault;
var
  DateList: TPlanMandatoryTimeList;
begin
  DateList := TPlanMandatoryTimeList.Create;

  if Assigned(PlanDataDefault) then
  begin
    DateListFromData(DateList, PlanDataDefault);
  end;

  DateListToForm(DateList);

  DateList.Free;
end;

procedure TDialogPanelMandatoryDays.ValueListMandatoryDatesMouseDown(
  Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  Col, Row: integer;
  Enabled: boolean;
  MousePos: TPoint;
begin
  if Button = mbRight then
  begin
    ValueListMandatoryDates.MouseToCell(X, Y, Col, Row);
    Enabled := mapRowToMandatoryGameList.ContainsKey(Row);
    if Enabled then
    begin
      ValueListMandatoryDates.Row := Row;
    end;

    PopupMenuBearbeiten.Enabled := Enabled;
    PopupMenuDelete.Enabled := Enabled;
    GetCursorPos(MousePos);
    PopupMenuMandatoryDays.Popup(MousePos.X, MousePos.Y);
  end;
end;

procedure TDialogPanelMandatoryDays.ValueListMandatoryDatesStringsChange(
  Sender: TObject);
begin
  if not InLoad then
  begin
    FireOnChange();
  end;
end;

end.
