unit DialogPanelMainData;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, EditMandatoryDatesDialog, Vcl.Menus, DialogPanelOptionArray, DialogForSingleGewichtungsOptions,
  DialogPanel, PlanDataObjects;

type
  TDialogPanelMainData = class(TDialogPanel)
    PanelMain: TPanel;
    PanelMandatoryDatesTop: TPanel;
    DateTimePickerUntil: TDateTimePicker;
    Label6: TLabel;
    DateTimePickerMid: TDateTimePicker;
    Label5: TLabel;
    DateTimePickerFrom: TDateTimePicker;
    Label4: TLabel;
    Label3: TLabel;
    EditId: TEdit;
    Label2: TLabel;
    EditName: TEdit;
    Label1: TLabel;
    ComboBoxArt: TComboBox;
    Label7: TLabel;
    procedure ControlChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
  public
    procedure setPanel(PanelMain: TPanel); override;
    procedure DataToForm(); override;
    procedure FormToData(); override;
    procedure toDefault(); override;
    function  isDefault(): boolean; override;
    function  CheckData(): boolean; override;

  end;


implementation

{$R *.dfm}



{ TDialogPanelFreeDays }

procedure TDialogPanelMainData.DataToForm;
var
  year, Month, Day: Word;
begin
  EditName.Text := PlanData.root.GetAsString(aName);
  ComboBoxArt.Text := PlanData.root.GetAsString(aGender);
  EditId.Text := PlanData.root.GetAsString(aID);

  if PlanData.root.GetAsDate(aFrom) <> 0 then
  begin
    DateTimePickerFrom.Date := PlanData.root.GetAsDate(aFrom);
    DateTimePickerUntil.Date := PlanData.root.GetAsDate(aUntil);
    DateTimePickerMid.Date := PlanData.root.GetAsDate(aMid);
  end
  else
  begin
    DecodeDate(now, year, Month, Day);
    DateTimePickerFrom.Date := EncodeDate(year, 7, 1);
    DateTimePickerMid.Date := EncodeDate(year, 12, 30);
    DateTimePickerUntil.Date := EncodeDate(year+1, 5, 1);
  end;


end;


function TDialogPanelMainData.CheckData: boolean;
begin
  Result := True;
  if Trim(EditName.Text) = '' then
  begin
    ShowMessage('Der Liganame darf nicht leer sein');
    Result := False;
    Exit;
  end;
  if Trim(EditId.Text) = '' then
  begin
    ShowMessage('Die Liganummer darf nicht leer sein');
    Result := False;
    Exit;
  end;
  if Trim(ComboBoxArt.Text) = '' then
  begin
    ShowMessage('Die Art (Herren/Damen) darf nicht leer sein');
    Result := False;
    Exit;
  end;
  if DateTimePickerUntil.Date <= DateTimePickerMid.Date then
  begin
    ShowMessage('Das Ende der Rckrunde muss nach dem Start der Rckrunde sein');
    Result := False;
    Exit;
  end;
  if DateTimePickerMid.Date <= DateTimePickerFrom.Date then
  begin
    ShowMessage('Der Start der Rckrunde muss nach dem Start der Vorrunde sein');
    Result := False;
    Exit;
  end;

end;

procedure TDialogPanelMainData.ControlChange(Sender: TObject);
begin
  FireOnChange();
end;

procedure TDialogPanelMainData.FormCreate(Sender: TObject);
begin
  GetGenderList(ComboBoxArt.Items);
  FixControls(Self);
end;

procedure TDialogPanelMainData.FormToData;
begin
  PlanData.root.SetAsString(aName, EditName.Text);
  PlanData.root.SetAsString(aGender, ComboBoxArt.Text);
  PlanData.root.SetAsString(aID, EditId.Text);
  PlanData.root.SetAsDate(aFrom, DateTimePickerFrom.Date);
  PlanData.root.SetAsDate(aUntil, DateTimePickerUntil.Date);
  PlanData.root.SetAsDate(aMid, DateTimePickerMid.Date);
end;

function TDialogPanelMainData.isDefault: boolean;
begin
  if (PlanDataDefault.root.GetAsString(aName) = EditName.Text)
      and (PlanDataDefault.root.GetAsString(aGender) = ComboBoxArt.Text)
      and (PlanDataDefault.root.GetAsString(aID) = EditId.Text)
      and (PlanDataDefault.root.GetAsDate(aFrom) = Trunc(DateTimePickerFrom.Date))
      and (PlanDataDefault.root.GetAsDate(aUntil) = Trunc(DateTimePickerUntil.Date))
      and (PlanDataDefault.root.GetAsDate(aMid) = Trunc(DateTimePickerMid.Date)) then
  begin
    Result := True;
  end
  else
  begin
    Result := False;
  end;
end;

procedure TDialogPanelMainData.setPanel(PanelMain: TPanel);
begin
  Self.PanelMain.Parent := PanelMain;
end;

procedure TDialogPanelMainData.toDefault;
begin
  EditName.Text := PlanDataDefault.root.GetAsString(aName);
  ComboBoxArt.Text := PlanDataDefault.root.GetAsString(aGender);
  EditId.Text := PlanDataDefault.root.GetAsString(aID);
  DateTimePickerFrom.Date := PlanDataDefault.root.GetAsDate(aFrom);
  DateTimePickerUntil.Date := PlanDataDefault.root.GetAsDate(aUntil);
  DateTimePickerMid.Date := PlanDataDefault.root.GetAsDate(aMid);
end;

end.
