unit DialogPanelLocationsCompactDetail;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, Vcl.Menus,
  DialogPanel, PlanDataObjects, System.UITypes, DialogTeamPanel, DialogEditSisterTeam;

type
  TDialogPanelLocationsCompactDetail = class(TDialogTeamPanel)
    PanelMain: TPanel;
    ValueListSisterTeams: TValueListEditor;
    Panel1: TPanel;
    Label1: TLabel;
    Label4: TLabel;
    ComboLocation: TComboBox;
    LabelKoppelPrio: TLabel;
    Panel2: TPanel;
    Panel3: TPanel;
    ValueListHomeDays: TValueListEditor;
    Panel4: TPanel;
    Label2: TLabel;
    procedure ValueListSisterTeamsStringsChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ComboLocationChange(Sender: TObject);
    procedure ValueListSisterTeamsMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  private
    InLoad: boolean;
    procedure EnableButtons();
    function  getMainNode(PlanData: TPlanData): TDataObject;
    function getSelectedSisterNode: TDataObject;
    function  SisterNodeToString(SisterNode: TDataObject): String;
    procedure FillCombos;
    procedure DataToHomeDayList();
    procedure HomeDayListToData();
    procedure FillComboHomeDayList;
    function FindSisterNodeByKey(Key: String): TDataObject;
    procedure TeamsDblClick;
  public
    procedure setPanel(PanelMain: TPanel); override;
    procedure DataToForm(); override;
    procedure FormToData(); override;
    procedure toDefault(); override;
    function  isDefault(): boolean; override;
  end;


implementation

{$R *.dfm}

function TDialogPanelLocationsCompactDetail.SisterNodeToString(SisterNode: TDataObject): String;
begin
  Result := '(' + SisterNode.GetAsString(aGender) + ') ' + SisterNode.GetAsString(aTeamName);
end;

procedure TDialogPanelLocationsCompactDetail.FillCombos();
var
  Key: String;
  TeamNode, SisterNode: TDataObject;
  Row: integer;
  ItemProp: TItemProp;
begin
  FillComboHomeDayList();

  TeamNode := getMainNode(PlanData);
  if Assigned(TeamNode) then
  begin
    for SisterNode in TeamNode.NamedChilds(nSisterTeam) do
    begin
      Key := SisterNodeToString(SisterNode);
      if ValueListSisterTeams.FindRow(Key, Row) then
      begin
        ItemProp := ValueListSisterTeams.ItemProps[Row - 1];
        PlanData.getTeamLocationsInt(ItemProp.PickList);
      end;
    end;
  end;
end;

procedure TDialogPanelLocationsCompactDetail.ComboLocationChange(Sender: TObject);
begin
  FormToData();
  FillCombos();
end;

function TDialogPanelLocationsCompactDetail.FindSisterNodeByKey(Key: String): TDataObject;
var
  TeamNode, SisterNode: TDataObject;
begin
  Result := nil;
  TeamNode := getMainNode(PlanData);
  if Assigned(TeamNode) then
  begin
    for SisterNode in TeamNode.NamedChilds(nSisterTeam) do
    begin
      if Key = SisterNodeToString(SisterNode) then
      begin
        Result := SisterNode;
      end;
    end;
  end;
end;

procedure TDialogPanelLocationsCompactDetail.DataToForm;
var
  Key, Value: String;
  SomeThingFound: boolean;
  TeamNode, SisterNode: TDataObject;
  ItemProp: TItemProp;
  row: integer;
  SisterTeams: TStringList;
begin
  InLoad := True;
  try
    PlanData.getTeamLocationsInt(ComboLocation.Items);
    TeamNode := getMainNode(PlanData);
    if Assigned(TeamNode) then
    begin
      SetListComboValue(ComboLocation, TeamNode.GetAsString(aLocation));

      DataToHomeDayList();

      SomeThingFound := False;
      ValueListSisterTeams.Strings.Clear;

      SisterTeams := TStringList.Create;

      for SisterNode in TeamNode.NamedChilds(nSisterTeam) do
      begin
        SisterTeams.Add(SisterNodeToString(SisterNode));
      end;

      SisterTeams.Sort;


      for Key in SisterTeams do
      begin
        SisterNode := FindSisterNodeByKey(Key);
        if Assigned(Sisternode) then
        begin
          Value := PlanData.FixLocation(SisterNode.GetAsString(aLocation));
          row := ValueListSisterTeams.InsertRow(Key, Value, True);
          ItemProp := ValueListSisterTeams.ItemProps[Row - 1];
          ItemProp.EditStyle := esPickList;
          SomeThingFound := True;
        end;
      end;

      SisterTeams.Free;

      if not SomeThingFound then
      begin
        ValueListSisterTeams.InsertRow('Keine Nachbarmannschaften vorhanden', '', True);
      end;
      EnableButtons();
    end;
    FillCombos();
  finally
    InLoad := False;
  end;
end;


procedure TDialogPanelLocationsCompactDetail.DataToHomeDayList();
var
  Key, Value: String;
  SomeThingFound: boolean;
  ItemProp: TItemProp;
  row: integer;
  HomeDays: THomeDayList;
  HomeDay: THomeDay;
begin
  HomeDays := THomeDayList.Create;
  PlanData.GetHomeDays(TeamName, HomeDays);
  SomeThingFound := False;
  ValueListHomeDays.Strings.Clear;

  for HomeDay in HomeDays do
  begin
    if HomeDay.IsHomeDay then
    begin
      Key := MyFormatDate(HomeDay.Date);
      Value := HomeDay.Location;
      row := ValueListHomeDays.InsertRow(Key, Value, True);
      ItemProp := ValueListHomeDays.ItemProps[Row - 1];
      ItemProp.EditStyle := esPickList;
      SomeThingFound := True;
    end;
  end;

  if not SomeThingFound then
  begin
    ValueListHomeDays.InsertRow('Keine Wunschtermine vorhanden', '', True);
  end;
  HomeDays.Free;
end;

procedure TDialogPanelLocationsCompactDetail.FillComboHomeDayList();
var
  Key: String;
  ItemProp: TItemProp;
  row: integer;
  HomeDays: THomeDayList;
  HomeDay: THomeDay;
begin
  HomeDays := THomeDayList.Create;
  PlanData.GetHomeDays(TeamName, HomeDays);
  for HomeDay in HomeDays do
  begin
    if HomeDay.IsHomeDay then
    begin
      Key := MyFormatDate(HomeDay.Date);
      if ValueListHomeDays.FindRow(Key, Row) then
      begin
        ItemProp := ValueListHomeDays.ItemProps[Row - 1];
        PlanData.getTeamLocationsInt(ItemProp.PickList);
      end;
    end;
  end;
  HomeDays.Free;
end;


procedure TDialogPanelLocationsCompactDetail.EnableButtons;
begin
end;


procedure TDialogPanelLocationsCompactDetail.FormCreate(Sender: TObject);
begin
  ValueListSisterTeams.DefaultRowHeight := MulDiv(ValueListSisterTeams.DefaultRowHeight, Screen.PixelsPerInch, 96);
  ValueListHomeDays.DefaultRowHeight := MulDiv(ValueListHomeDays.DefaultRowHeight, Screen.PixelsPerInch, 96);
  FixControls(Self);
end;

procedure TDialogPanelLocationsCompactDetail.FormToData;
var
  Key, Value: String;
  TeamNode, SisterNode: TDataObject;
begin
  TeamNode := getMainNode(PlanData);
  if Assigned(TeamNode) then
  begin
    TeamNode.SetAsString(aLocation, GetListComboValue(ComboLocation));

    HomeDayListToData();

    for SisterNode in TeamNode.NamedChilds(nSisterTeam) do
    begin
      Key := SisterNodeToString(SisterNode);
      Value := Trim(ValueListSisterTeams.Values[Key]);
      if not PlanData.isValidLocation(Value) then
      begin
        Value := '';
        ValueListSisterTeams.Values[Key] := Value;
      end;

      SisterNode.SetAsString(aLocation, Value);
    end;
  end;
end;

procedure TDialogPanelLocationsCompactDetail.HomeDayListToData();
var
  Key, Value: String;
  HomeDays: THomeDayList;
  HomeDay: THomeDay;
begin
  HomeDays := THomeDayList.Create;
  PlanData.GetHomeDays(TeamName, HomeDays);
  for HomeDay in HomeDays do
  begin
    if HomeDay.IsHomeDay then
    begin
      Key := MyFormatDate(HomeDay.Date);
      Value := Trim(ValueListHomeDays.Values[Key]);
      if not PlanData.isValidLocation(Value) then
      begin
        Value := '';
        ValueListHomeDays.Values[Key] := Value;
      end;

      HomeDay.Location := Value;
    end;
  end;
  PlanData.SetHomeDays(TeamName, HomeDays);
  HomeDays.Free;
end;



function TDialogPanelLocationsCompactDetail.getMainNode(PlanData: TPlanData): TDataObject;
var
  DataKey: TDataObjectKey;
  Index: integer;
begin
  Result := nil;
  DataKey := TDataObjectKey.Create;
  DataKey.Name := nTeam;
  DataKey.setAttribute(aTeamName, TeamName);
  Index := PlanData.root.findChildIndexByKey(DataKey);

  if Index >= 0  then
  begin
    Result := PlanData.root.childs[Index];
  end;

  DataKey.Free;
end;



function TDialogPanelLocationsCompactDetail.getSelectedSisterNode: TDataObject;
var
  Key: String;
  TeamNode, SisterNode: TDataObject;
  row: integer;
begin
  Result := nil;
  TeamNode := getMainNode(PlanData);
  if Assigned(TeamNode) then
  begin
    for SisterNode in TeamNode.NamedChilds(nSisterTeam) do
    begin
      Key := SisterNodeToString(SisterNode);

      if ValueListSisterTeams.FindRow(Key, row) then
      begin
        if row = ValueListSisterTeams.Row then
        begin
          Result := SisterNode;
        end;
      end;
    end;
  end;
end;

function TDialogPanelLocationsCompactDetail.isDefault: boolean;
var
  i: integer;
  Value: String;
begin
  Result := GetListComboValue(ComboLocation) = '';
  for i := 0 to ValueListSisterTeams.Strings.Count-1 do
  begin
    if Trim(ValueListSisterTeams.Values[ValueListSisterTeams.Keys[i+1]]) <> '' then
    begin
      result := false;
    end;
  end;
  for i := 0 to ValueListHomeDays.Strings.Count-1 do
  begin
    Value := Trim(ValueListHomeDays.Values[ValueListHomeDays.Keys[i+1]]);
    if (Value <> '') and (Value <> GetListComboValue(ComboLocation)) then
    begin
      result := false;
    end;
  end;
end;

procedure TDialogPanelLocationsCompactDetail.setPanel(PanelMain: TPanel);
begin
  Self.PanelMain.Parent := PanelMain;
end;


procedure TDialogPanelLocationsCompactDetail.toDefault;
var
  i: integer;
begin
  InLoad := True;
  try
    SetListComboValue(ComboLocation, '');

    for i := 0 to ValueListSisterTeams.Strings.Count-1 do
    begin
      ValueListSisterTeams.Values[ValueListSisterTeams.Keys[i+1]] := '';
    end;

    for i := 0 to ValueListHomeDays.Strings.Count-1 do
    begin
      ValueListHomeDays.Values[ValueListHomeDays.Keys[i+1]] := '';
    end;


    FormToData;
    DataToForm;
    FireOnChange;
  finally
    InLoad := False;
  end;
end;

procedure TDialogPanelLocationsCompactDetail.TeamsDblClick();
var
  Dialog: TDialogEditSisterTeam;
begin
  if Assigned(getSelectedSisterNode())  then
  begin
    Dialog := TDialogEditSisterTeam.Create(Self);
    Dialog.SetValues(getSelectedSisterNode, PlanData, TeamName);
    if mrOK = Dialog.ShowModal then
    begin
      Dialog.GetValues(getSelectedSisterNode);
      DataToForm();
      FireOnChange();
    end;
    Dialog.Free;
  end;
end;

procedure TDialogPanelLocationsCompactDetail.ValueListSisterTeamsMouseDown(
  Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  Col, Row: integer;
begin
  ValueListSisterTeams.MouseToCell(X, Y, Col, Row);

  if Row > 0 then
  begin
    ValueListSisterTeams.Row := Row;
  end;

  if (Col = 0) and (Button = mbLeft) and (ssDouble in Shift) then
  begin
    TeamsDblClick();
  end;

end;

procedure TDialogPanelLocationsCompactDetail.ValueListSisterTeamsStringsChange(
  Sender: TObject);
begin
  if not InLoad then
  begin
    FormToData();
    FireOnChange();
    FillCombos();
  end;
end;

end.
