unit DialogPanelHomeRightDetail;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, Vcl.Menus,
  DialogPanel, PlanDataObjects, System.UITypes, DialogTeamPanel, DialogEditSisterTeam;

type
  TDialogPanelHomeRightDetail = class(TDialogTeamPanel)
    PanelMain: TPanel;
    Panel1: TPanel;
    Label1: TLabel;
    ComboNumberHome: TComboBox;
    LabelKoppelPrio: TLabel;
    Panel3: TPanel;
    ValueListHomeRights: TValueListEditor;
    procedure ValueListSisterTeamsStringsChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ComboNumberHomeChange(Sender: TObject);
  private
    InLoad: boolean;
    procedure EnableButtons();
    function  getMainNode(PlanData: TPlanData): TDataObject;
    procedure DataToHomeDayList();
    procedure HomeDayListToData();
    procedure FillComboNumberHome(NumberOfTeams: Integer);
  public
    procedure setPanel(PanelMain: TPanel); override;
    procedure DataToForm(); override;
    procedure FormToData(); override;
    procedure toDefault(); override;
    function  isDefault(): boolean; override;
  end;


implementation

{$R *.dfm}


procedure TDialogPanelHomeRightDetail.ComboNumberHomeChange(Sender: TObject);
begin
  FormToData();
end;

procedure TDialogPanelHomeRightDetail.DataToForm;
var
  TeamNode: TDataObject;
  TeamNames: TStrings;
begin
  InLoad := True;
  try
    TeamNames := TStringList.Create;
    PlanData.getTeamNames(TeamNames);
    FillComboNumberHome(TeamNames.Count);
    TeamNode := getMainNode(PlanData);
    if Assigned(TeamNode) then
    begin
      ComboNumberHome.ItemIndex := TeamNode.GetAsInt(aHomeRights) + 1;

      DataToHomeDayList();

      EnableButtons();
    end;
    TeamNames.Free;
  finally
    InLoad := False;
  end;
end;


procedure TDialogPanelHomeRightDetail.DataToHomeDayList();
var
  Value: String;
  ItemProp: TItemProp;
  row: integer;
  GuestTeam: String;
  TeamsRound1: TStrings;
  TeamsRound2: TStrings;
  HomeRightsNode: TDataObject;
  HomeRightValue: integer;
  Team2Name: String;
  TeamNames: TStrings;
begin

  TeamsRound1 := TStringList.Create;
  TeamsRound2 := TStringList.Create;

  TeamNames := TStringList.Create;
  PlanData.getTeamNames(TeamNames);

  for HomeRightsNode in getMainNode(PlanData).NamedChilds(nHomeRights) do
  begin
    HomeRightValue := HomeRightsNode.GetAsInt(aHomeRight);
    Team2Name := HomeRightsNode.GetAsString(aTeamName);

    if HomeRightValue = 1 then
    begin
      TeamsRound1.Add(Team2Name);
    end;

    if HomeRightValue = 2 then
    begin
      TeamsRound2.Add(Team2Name);
    end;

  end;

  ValueListHomeRights.Strings.Clear;

  for GuestTeam in TeamNames do
  begin
    if GuestTeam <> TeamName then
    begin
      Value := 'egal';
      if 0 <= TeamsRound1.IndexOf(GuestTeam) then
      begin
        Value := 'Vorrunde';
      end;
      if 0 <= TeamsRound2.IndexOf(GuestTeam) then
      begin
        Value := 'Rckrunde';
      end;

      row := ValueListHomeRights.InsertRow(GuestTeam, Value, True);
      ItemProp := ValueListHomeRights.ItemProps[Row - 1];
      ItemProp.EditStyle := esPickList;
      ItemProp.PickList.Add('Vorrunde');
      ItemProp.PickList.Add('egal');
      ItemProp.PickList.Add('Rckrunde');
      ItemProp.ReadOnly := True;
    end;
  end;

  TeamsRound1.Free;
  TeamsRound2.Free;
  TeamNames.Free;
end;


procedure TDialogPanelHomeRightDetail.FillComboNumberHome(NumberOfTeams: Integer);
var
  i: Integer;
begin
  ComboNumberHome.Items.Clear;
  ComboNumberHome.Items.Add('Automatisch');

  for i := 0 to NumberOfTeams-1 do
  begin
    ComboNumberHome.Items.Add('Vorrunde: ' + IntToStr(i) + '      Rckrunde: ' + IntToStr(NumberOfTeams - i - 1));
  end;
end;

procedure TDialogPanelHomeRightDetail.EnableButtons;
begin
end;


procedure TDialogPanelHomeRightDetail.FormCreate(Sender: TObject);
begin
  ValueListHomeRights.DefaultRowHeight := MulDiv(ValueListHomeRights.DefaultRowHeight, Screen.PixelsPerInch, 96);
  FixControls(Self);
end;

procedure TDialogPanelHomeRightDetail.FormToData;
var
  TeamNode: TDataObject;
begin
  TeamNode := getMainNode(PlanData);
  if Assigned(TeamNode) then
  begin
    TeamNode.SetAsInt(aHomeRights, ComboNumberHome.ItemIndex-1);

    HomeDayListToData();

  end;
end;

procedure TDialogPanelHomeRightDetail.HomeDayListToData();
var
  TeamNode: TDataObject;
  TeamNames: TStrings;
  GuestTeam, Value: String;
  HomeRightValue: Integer;
  newNode: TDataObject;
begin
  TeamNode := getMainNode(PlanData);
  TeamNode.deleteChilds(nHomeRights);

  TeamNames := TStringList.Create;
  PlanData.getTeamNames(TeamNames);

  for GuestTeam in TeamNames do
  begin
    HomeRightValue := 0;
    Value := ValueListHomeRights.Values[GuestTeam];

    if Value = 'Vorrunde' then
    begin
      HomeRightValue := 1;
    end;

    if Value = 'Rckrunde' then
    begin
      HomeRightValue := 2;
    end;

    if HomeRightValue <> 0 then
    begin
      newNode := TDataObject.Create(nHomeRights, TeamNode);
      newNode.SetAsString(aTeamName, GuestTeam);
      newNode.SetAsInt(aHomeRight, HomeRightValue);
    end;
  end;
  TeamNames.Free;
end;



function TDialogPanelHomeRightDetail.getMainNode(PlanData: TPlanData): TDataObject;
var
  DataKey: TDataObjectKey;
  Index: integer;
begin
  Result := nil;
  DataKey := TDataObjectKey.Create;
  DataKey.Name := nTeam;
  DataKey.setAttribute(aTeamName, TeamName);
  Index := PlanData.root.findChildIndexByKey(DataKey);

  if Index >= 0  then
  begin
    Result := PlanData.root.childs[Index];
  end;

  DataKey.Free;
end;




function TDialogPanelHomeRightDetail.isDefault: boolean;
var
  i: integer;
  Value: String;
begin
  Result := ComboNumberHome.ItemIndex = 0;
  for i := 0 to ValueListHomeRights.Strings.Count-1 do
  begin
    Value := Trim(ValueListHomeRights.Values[ValueListHomeRights.Keys[i+1]]);
    if (Value <> 'egal') then
    begin
      result := false;
    end;
  end;
end;

procedure TDialogPanelHomeRightDetail.setPanel(PanelMain: TPanel);
begin
  Self.PanelMain.Parent := PanelMain;
end;


procedure TDialogPanelHomeRightDetail.toDefault;
var
  i: integer;
begin
  InLoad := True;
  try
    ComboNumberHome.ItemIndex := 0;

    for i := 0 to ValueListHomeRights.Strings.Count-1 do
    begin
      ValueListHomeRights.Values[ValueListHomeRights.Keys[i+1]] := 'egal';
    end;
    FormToData;
    DataToForm;
    FireOnChange;
  finally
    InLoad := False;
  end;
end;

procedure TDialogPanelHomeRightDetail.ValueListSisterTeamsStringsChange(
  Sender: TObject);
begin
  if not InLoad then
  begin
    FormToData();
    FireOnChange();
  end;
end;

end.
