unit DialogPanelHomeDays;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, EditMandatoryDatesDialog, Vcl.Menus, DialogPanelOptionArray, DialogForSingleGewichtungsOptions,
  DialogPanel, PlanDataObjects, DialogEditTeamName, System.UITypes, DialogPanelMultiTeams, DialogTeamPanel,
  DialogPanelHomeDaysDetail;

type
  TDialogPanelHomeDays = class(TDialogPanelMultiTeams)
  public
    function getDialogClass(): TDialogTeamPanelClass; override;
    function getCaption(): String; override;
    function getHeaderText(): String; override;
  end;


implementation


{ TDialogPanelHomeDays }

function TDialogPanelHomeDays.getCaption: String;
begin
  Result := 'Wunschtermine';
end;

function TDialogPanelHomeDays.getDialogClass: TDialogTeamPanelClass;
begin
  Result := TDialogPanelHomeDaysDetail;
end;

function TDialogPanelHomeDays.getHeaderText: String;
begin
  Result := 'Beispiele fr die Termineingabe:'
            + cNewLine  + '18:00: Mannschaft kann um 18:00 Uhr ein Heimspiel austragen.'
            + cNewLine  + 'FREI: Eingabe des Textes ''FREI'' bedeutet, dass die Mannschaft an diesem Tag kein Spiel machen will.'
            + cNewLine  + 'Keine Eingabe: Die Mannschaft kann an diesem Tag ein Auswrtsspiel wahrnehmen.'
            + cNewLine  + cNewLine  + 'Weitere Optionen (maximale Heimspiele, Koppeloptionen, Ausweichtermin etc.) mit Doppelklick oder Maus rechts.';
end;

end.
