unit DialogPanelFreeDays;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, EditMandatoryDatesDialog, Vcl.Menus, DialogPanelOptionArray, DialogForSingleGewichtungsOptions,
  DialogPanel, PlanDataObjects;

type
  TDialogPanelFreeDays = class(TDialogPanel)
    PanelMain: TPanel;
    Label1: TLabel;
    ListViewFreeDates: TListView;
    PanelTop: TPanel;
    PanelBottom: TPanel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ListViewFreeDatesClick(Sender: TObject);
  private
    DefaultValues: TList<TDateTime>;
    procedure FormToDateList(ResultDateList: TList<TDateTime>);
    procedure DateListToForm(DateList: TList<TDateTime>);
    procedure DateListFromData(DateList: TList<TDateTime>; PlanData: TPlanData);
  public
    procedure setPanel(PanelMain: TPanel); override;
    procedure DataToForm(); override;
    procedure FormToData(); override;
    procedure toDefault(); override;
    function  isDefault(): boolean; override;

  end;


implementation

{$R *.dfm}



{ TDialogPanelFreeDays }

procedure TDialogPanelFreeDays.DataToForm;
var
  DateList: TList<TDateTime>;
begin
  DateList := TList<TDateTime>.Create;
  DateListFromData(DateList, PlanData);
  DateListToForm(DateList);
  DateList.Free;
end;


procedure TDialogPanelFreeDays.DateListFromData(DateList: TList<TDateTime>; PlanData: TPlanData);
var
  DayNode: TDataObject;
  AllDateList: TList<TDateTime>;
  i: Integer;
begin
  AllDateList := TList<TDateTime>.Create;
  PlanData.getAllPossibleDates(AllDateList);

  DateList.Clear;

  for DayNode in PlanData.root.NamedChilds(nNoGameDay) do
  begin
    DateList.Add(DayNode.GetAsDate(aDate));
  end;

  // Komplett unsinnige Termine entfernen
  for i := DateList.Count-1 downto 0 do
  begin
    if not AllDateList.Contains(DateList[i]) then
    begin
      DateList.Delete(i)
    end;
  end;

  DateList.Sort;

  AllDateList.Free;
end;


procedure TDialogPanelFreeDays.DateListToForm(DateList: TList<TDateTime>);
var
  AllDateList: TList<TDateTime>;
  Date: TDateTime;
begin
  AllDateList := TList<TDateTime>.Create;
  PlanData.getAllPossibleDates(AllDateList);

  ListViewFreeDates.Items.Clear;

  for Date in AllDateList do
  begin
    ListViewFreeDates.AddItem(MyFormatDate(Date), nil);

    if DateList.Contains(Date) then
    begin
      ListViewFreeDates.Items[ListViewFreeDates.Items.Count-1].Checked := True;
    end;
  end;
  AllDateList.Free;
end;


procedure TDialogPanelFreeDays.FormCreate(Sender: TObject);
begin
  DefaultValues := TList<TDateTime>.Create;
  FixControls(Self);
end;

procedure TDialogPanelFreeDays.FormDestroy(Sender: TObject);
begin
  DefaultValues.Free;
end;

procedure TDialogPanelFreeDays.FormToData;
var
  DateList: TList<TDateTime>;
  Date: TDateTime;
  NewElem: TDataObject;
begin
  PlanData.root.deleteChilds(nNoGameDay);

  DateList := TList<TDateTime>.Create;
  FormToDateList(DateList);

  for Date in DateList do
  begin
    NewElem := TDataObject.Create(nNoGameDay, PlanData.root);
    NewElem.SetAsDate(aDate, Date);
  end;
  DateList.Free;
end;


procedure TDialogPanelFreeDays.FormToDateList(ResultDateList: TList<TDateTime>);
var
  i: integer;
  Date: TDateTime;
  DateList: TList<TDateTime>;
begin
  ResultDateList.Clear;
  DateList := TList<TDateTime>.Create;
  PlanData.getAllPossibleDates(DateList);

  for i := 0 to DateList.Count - 1 do
  begin
    Date := DateList[i];
    if ListViewFreeDates.Items[i].Checked then
    begin
      ResultDateList.Add(Date);
    end;
  end;
  DateList.Free;
end;


function TDialogPanelFreeDays.isDefault: boolean;
var
  DateList1, DateList2: TList<TDateTime>;
  Date: TDateTime;
begin
  DateList1 := TList<TDateTime>.Create;
  DateList2 := TList<TDateTime>.Create;

  if Assigned(PlanDataDefault) then
  begin
    DateListFromData(DateList1, PlanDataDefault);
  end;

  FormToData();

  DateListFromData(DateList2, PlanData);

  Result := DateList1.Count = DateList2.Count;

  for Date in DateList1 do
  begin
    if not DateList2.Contains(Date) then
    begin
      Result := False;
    end;
  end;

  DateList1.Free;
  DateList2.Free;
end;

procedure TDialogPanelFreeDays.ListViewFreeDatesClick(Sender: TObject);
begin
  FireOnChange();
end;

procedure TDialogPanelFreeDays.setPanel(PanelMain: TPanel);
begin
  Self.PanelMain.Parent := PanelMain;
end;

procedure TDialogPanelFreeDays.toDefault;
var
  DateList: TList<TDateTime>;
begin
  DateList := TList<TDateTime>.Create;

  if Assigned(PlanDataDefault) then
  begin
    DateListFromData(DateList, PlanDataDefault);
  end;

  DateListToForm(DateList);

  DateList.Free;
end;

end.
