unit DialogPanelAuswaertsKoppelDetail;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, Vcl.Menus, DialogPanelOptionArray,
  DialogPanel, PlanDataObjects, System.UITypes, DialogTeamPanel, DialogEditOneAuswaertsKoppel;

type
  TDialogPanelAuswaertsKoppelDetail = class(TDialogTeamPanel)
    PanelMain: TPanel;
    ButtonTeamDelete: TButton;
    ButtonTeamEdit: TButton;
    ButtonTeamNew: TButton;
    ListBoxTeams: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    PopupMenuAusweichTermine: TPopupMenu;
    Allesselektieren1: TMenuItem;
    Allesdeselektieren1: TMenuItem;
    ValueListSecondTime: TValueListEditor;
    procedure ControlChange(Sender: TObject);
    procedure ButtonTeamEditClick(Sender: TObject);
    procedure ButtonTeamDeleteClick(Sender: TObject);
    procedure ListBoxTeamsClick(Sender: TObject);
    procedure ButtonTeamNewClick(Sender: TObject);
    procedure ListBoxTeamsDblClick(Sender: TObject);
    procedure Allesdeselektieren1Click(Sender: TObject);
    procedure Allesselektieren1Click(Sender: TObject);
    procedure ValueListSecondTimeStringsChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    InLoad: boolean;
    procedure EnableButtons();
    function getMainNode(PlanData: TPlanData): TDataObject;
    function getSelectedNode: TDataObject;
    function KoppelNodeToString(Node: TDataObject): String;
    procedure DataToAusweichList;
    function HomeDayToString(HomeDay: THomeDay): String;
    function WunschTermineNeedsTimeshiftForAuswaertskoppel(HomeDay: THomeDay): boolean;

  public
    procedure setPanel(PanelMain: TPanel); override;
    procedure DataToForm(); override;
    procedure FormToData(); override;
    procedure toDefault(); override;
    function  isDefault(): boolean; override;
  end;


implementation

{$R *.dfm}



function TDialogPanelAuswaertsKoppelDetail.KoppelNodeToString(Node: TDataObject): String;
var
  typeString: String;
begin
  case Node.GetAsInt(aSameDay) of
    0: typeString := 'am gleichen Tag';
    1: typeString := 'mit bernachtung';
    2: typeString := 'am gleichen Tag oder mit bernachtung';
  end;

  Result := Node.GetAsString(aTeamNameA) + ', ' + Node.GetAsString(aTeamNameB) + ' (' + typeString + ')';
end;


function TDialogPanelAuswaertsKoppelDetail.HomeDayToString(HomeDay: THomeDay): String;
begin
  Result := MyFormatDate(Trunc(HomeDay.Date)) + ' ' + MyFormatTime(HomeDay.Date + Trunc(HomeDay.Date));
end;


// Bei diese Wunschtermine msste man eine andere Zeit nehmen, damit ein Auswrtskoppeltermin zustande kommt
function TDialogPanelAuswaertsKoppelDetail.WunschTermineNeedSTimeshiftForAuswaertskoppel(HomeDay: THomeDay): boolean;
var
  TeamNode: TDataObject;
  KoppelNode: TDataObject;
  KoppelOption: integer;
  TeamA, TeamB, TeamOther: String;
  HomeDaysOtherTeam: THomeDayList;
  HomeDayOtherTeam: THomeDay;
begin
  Result := False;

  if HomeDay.KoppelDate then
  begin
    Exit;
  end;

  // ber alle anderen Mannschaften, ob von diesen Auswrtskoppeltermine
  for TeamNode in PlanData.root.NamedChilds(nTeam) do
  begin
    if TeamNode.GetAsString(aTeamName) <> TeamName then
    begin
      // Teste die Auswrtskoppeltermine
      for KoppelNode in TeamNode.NamedChilds(nRoadCouple) do
      begin
        KoppelOption := KoppelNode.GetAsInt(aSameDay);
        TeamOther := '';
        TeamA := KoppelNode.GetAsString(aTeamNameA);
        TeamB := KoppelNode.GetAsString(aTeamNameB);

        if TeamA = TeamName then
        begin
          TeamOther := TeamB;
        end;

        if TeamB = TeamName then
        begin
          TeamOther := TeamA;
        end;

        if (TeamOther <> '') and (TeamOther <> TeamName)then
        begin
          if (KoppelOption = 0) or (KoppelOption = 2) then
          begin
            HomeDaysOtherTeam := THomeDayList.Create;
            PlanData.GetHomeDays(TeamOther, HomeDaysOtherTeam);

            for HomeDayOtherTeam in HomeDaysOtherTeam do
            begin
              if HomeDayOtherTeam.IsHomeDay then
              begin
                if Trunc(HomeDay.Date) = Trunc(HomeDayOtherTeam.Date) then
                begin
                  if MinGameDistance > Abs(HomeDay.Date - HomeDayOtherTeam.Date) then
                  begin
                    Result := True;
                  end;
                end;
              end;
            end;
            HomeDaysOtherTeam.Free;
          end;
        end;
      end;
    end;
  end;
end;



procedure TDialogPanelAuswaertsKoppelDetail.DataToAusweichList();
var
  HomeDays: THomeDayList;
  HomeDay: THomeDay;
  Key, Value: String;
  SomeThingFound: boolean;
begin
  InLoad := True;
  try
    SomeThingFound := False;
    HomeDays := THomeDayList.Create();
    PlanData.GetHomeDays(TeamName, HomeDays);

    ValueListSecondTime.Strings.Clear;

    for HomeDay in HomeDays do
    begin
      if HomeDay.IsHomeDay then
      begin
        if WunschTermineNeedsTimeshiftForAuswaertskoppel(HomeDay) then
        begin
          Key := HomeDayToString(HomeDay);
          Value := '';
          if HomeDay.KoppelAuswaertsSecondTime then
          begin
            Value := FormatTimeForExport(HomeDay.KoppelSecondTime);
          end;

          ValueListSecondTime.InsertRow(Key, Value, True);
          SomeThingFound := True;
        end;
      end;
    end;

    if not SomeThingFound then
    begin
      ValueListSecondTime.InsertRow('Keine relevanten Termine vorhanden', '', True);
    end;

    HomeDays.Free;

  finally
    InLoad := False;
  end;
end;


procedure TDialogPanelAuswaertsKoppelDetail.DataToForm;
var
  Names: TStringList;
  Node, TeamNode: TDataObject;
  OldIndex: integer;
begin
  OldIndex := ListBoxTeams.ItemIndex;

  Names := TStringList.Create;

  TeamNode := getMainNode(PlanData);

  if Assigned(TeamNode) then
  begin
    for Node in TeamNode.NamedChilds(nRoadCouple) do
    begin
      Names.Add(KoppelNodeToString(Node));
    end;
  end;

  Names.Sort;
  ListBoxTeams.Items := Names;
  Names.Free;

  if (OldIndex >= 0) and (OldIndex < ListBoxTeams.Items.Count) then
  begin
    ListBoxTeams.ItemIndex := OldIndex;
  end;

  DataToAusweichList();

  EnableButtons();
end;


procedure TDialogPanelAuswaertsKoppelDetail.EnableButtons;
begin
  ButtonTeamDelete.Enabled := Assigned(getSelectedNode());
  ButtonTeamEdit.Enabled := ButtonTeamDelete.Enabled;
end;

procedure TDialogPanelAuswaertsKoppelDetail.Allesdeselektieren1Click(Sender: TObject);
var
  i: integer;
begin
  InLoad := True;
  try
    for i := 0 to ValueListSecondTime.Strings.Count-1 do
    begin
      ValueListSecondTime.Values[ValueListSecondTime.Keys[i+1]] := '';
    end;
    FireOnChange();
  finally
    InLoad := False;
  end;
end;

procedure TDialogPanelAuswaertsKoppelDetail.Allesselektieren1Click(Sender: TObject);
var
  HomeDays: THomeDayList;
  HomeDay: THomeDay;
  Key: String;
  i: integer;
  OnlyTime: TDateTime;
begin
  InLoad := True;
  try
    HomeDays := THomeDayList.Create();
    PlanData.GetHomeDays(TeamName, HomeDays);

    for HomeDay in HomeDays do
    begin
      if HomeDay.IsHomeDay then
      begin
        Key := HomeDayToString(HomeDay);
        for i := 0 to ValueListSecondTime.Strings.Count-1 do
        begin
          if Key = ValueListSecondTime.Keys[i+1] then
          begin
            // Zweite Zeit ermitteln
            OnlyTime := HomeDay.Date - Trunc(HomeDay.Date);
            if OnlyTime > EncodeTime(16, 59, 0, 0) then
            begin
              // Der Koppeltermin ist spt, also muss das 2. Spiel davor sein
              OnlyTime := FixDateTime(OnlyTime - EncodeTime(4, 0, 0, 0));
            end
            else
            begin
              OnlyTime := FixDateTime(OnlyTime + EncodeTime(4, 0, 0, 0));
            end;

            ValueListSecondTime.Values[Key] := FormatTimeForExport(OnlyTime);
          end;
        end;
      end;
    end;

    HomeDays.Free;

    FireOnChange();

  finally
    InLoad := False;
  end;
end;

procedure TDialogPanelAuswaertsKoppelDetail.ButtonTeamDeleteClick(Sender: TObject);
var
  Node: TDataObject;
begin
  Node := getSelectedNode();
  if Assigned(Node) then
  begin
    if mrYes = MessageDlg('Mchten Sie den Auswrtskoppelwunsch ' + KoppelNodeToString(Node) + ' wirklich lschen?', mtConfirmation, [mbYes, mbNo], 0) then
    begin
      Node.parent.RemoveChild(Node);
      DataToForm();
      FireOnChange();
    end;
  end;
end;

procedure TDialogPanelAuswaertsKoppelDetail.ButtonTeamEditClick(Sender: TObject);
var
  Dialog: TDialogEditOneAuswaertsKoppel;
begin
  if Assigned(getSelectedNode())  then
  begin
    Dialog := TDialogEditOneAuswaertsKoppel.Create(Self);
    Dialog.SetValue(PlanData, getSelectedNode, TeamName);
    if mrOK = Dialog.ShowModal then
    begin
      Dialog.GetValue(getSelectedNode);
      DataToForm();
      FireOnChange();
    end;
    Dialog.Free;
  end;
end;




procedure TDialogPanelAuswaertsKoppelDetail.ButtonTeamNewClick(Sender: TObject);
var
  Dialog: TDialogEditOneAuswaertsKoppel;
  SisterNode: TDataObject;
begin
  Dialog := TDialogEditOneAuswaertsKoppel.Create(Self);
  Dialog.SetValue(PlanData, nil, TeamName);
  if mrOK = Dialog.ShowModal then
  begin
    SisterNode := TDataObject.Create(nRoadCouple, getMainNode(PlanData));
    Dialog.GetValue(SisterNode);
    DataToForm();
    FireOnChange();
  end;
  Dialog.Free;
end;

procedure TDialogPanelAuswaertsKoppelDetail.ControlChange(Sender: TObject);
begin
  FireOnChange();
end;

procedure TDialogPanelAuswaertsKoppelDetail.FormCreate(Sender: TObject);
begin
  ValueListSecondTime.DefaultRowHeight := MulDiv(ValueListSecondTime.DefaultRowHeight, Screen.PixelsPerInch, 96);
  FixControls(Self);
end;

procedure TDialogPanelAuswaertsKoppelDetail.FormToData;
var
  HomeDays: THomeDayList;
  HomeDay: THomeDay;
  Key: String;
  i: integer;
  OnlyTime: TDateTime;
begin
  HomeDays := THomeDayList.Create();
  PlanData.GetHomeDays(TeamName, HomeDays);

  for HomeDay in HomeDays do
  begin
    if HomeDay.IsHomeDay then
    begin
      Key := HomeDayToString(HomeDay);
      for i := 0 to ValueListSecondTime.Strings.Count-1 do
      begin
        if Key = ValueListSecondTime.Keys[i+1] then
        begin
          // Zweite Zeit ermitteln
          OnlyTime := TimeFromString(Trim(ValueListSecondTime.Values[Key]));

          if OnlyTime <> 0 then
          begin
            HomeDay.KoppelAuswaertsSecondTime := True;
            HomeDay.KoppelSecondTime := OnlyTime;
          end
          else
          begin
            HomeDay.KoppelAuswaertsSecondTime := False;
          end;
        end;
      end;
    end;
  end;

  PlanData.SetHomeDays(teamName, HomeDays);

  HomeDays.Free;
end;


function TDialogPanelAuswaertsKoppelDetail.getMainNode(PlanData: TPlanData): TDataObject;
var
  DataKey: TDataObjectKey;
  Index: integer;
begin
  Result := nil;
  DataKey := TDataObjectKey.Create;
  DataKey.Name := nTeam;
  DataKey.setAttribute(aTeamName, TeamName);
  Index := PlanData.root.findChildIndexByKey(DataKey);

  if Index >= 0  then
  begin
    Result := PlanData.root.childs[Index];
  end;

  DataKey.Free;
end;


function TDialogPanelAuswaertsKoppelDetail.getSelectedNode: TDataObject;
var
  MainNode, Node: TDataObject;
  S: String;
begin
  Result := nil;

  if ListBoxTeams.ItemIndex >= 0 then
  begin
    S := ListBoxTeams.Items[ListBoxTeams.ItemIndex];
    MainNode := getMainNode(PlanData);

    if Assigned(MainNode) then
    begin
      for Node in MainNode.NamedChilds(nRoadCouple) do
      begin
        if S = KoppelNodeToString(Node) then
        begin
          Result := Node;
        end;
      end;
    end;
  end;
end;

function TDialogPanelAuswaertsKoppelDetail.isDefault: boolean;
var
  Node1, Node2: TDataObject;
  i: integer;
begin
  Node1 := getMainNode(PlanData);
  Node2 := getMainNode(PlanDataDefault);

  Result := TDataObject.ChildNodesAreTheSame(Node1, Node2, nRoadCouple);

  for i := 0 to ValueListSecondTime.Strings.Count-1 do
  begin
    if Trim(ValueListSecondTime.Values[ValueListSecondTime.Keys[i+1]]) <> '' then
    begin
      result := false;
    end;
  end;

end;

procedure TDialogPanelAuswaertsKoppelDetail.ListBoxTeamsClick(Sender: TObject);
begin
  EnableButtons();
end;

procedure TDialogPanelAuswaertsKoppelDetail.ListBoxTeamsDblClick(Sender: TObject);
begin
  ButtonTeamEditClick(nil);
end;

procedure TDialogPanelAuswaertsKoppelDetail.setPanel(PanelMain: TPanel);
begin
  Self.PanelMain.Parent := PanelMain;
end;

procedure TDialogPanelAuswaertsKoppelDetail.toDefault;
var
  Node1, Node2, Node, NewNode: TDataObject;
begin
  Node1 := getMainNode(PlanData);
  Node2 := getMainNode(PlanDataDefault);

  while True do
  begin
    Node := Node1.FindChild(nRoadCouple);
    if Assigned(Node) then
    begin
      Node1.RemoveChild(Node);
    end
    else
    begin
      break;
    end;
  end;

  if Assigned(Node2) then
  begin
    for node in Node2.NamedChilds(nRoadCouple) do
    begin
      NewNode := TDataObject.Create(nRoadCouple, Node1);
      NewNode.assign(node);
    end;
  end;

  Allesdeselektieren1Click(nil);
  FormToData;

  DataToForm;
  FireOnChange;
end;

procedure TDialogPanelAuswaertsKoppelDetail.ValueListSecondTimeStringsChange(
  Sender: TObject);
begin
  if not InLoad then
  begin
    FireOnChange();
  end;
end;

end.
