unit DialogPanel60kmDetail;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, Vcl.Menus, DialogPanelOptionArray, DialogForSingleGewichtungsOptions,
  DialogPanel, PlanDataObjects, DialogTeamPanel;

type
  TDialogPanel60kmDetail = class(TDialogTeamPanel)
    PanelMain: TPanel;
    ListViewTeams: TListView;
    PanelBottom: TPanel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ListViewTeamsClick(Sender: TObject);
  private
    DefaultValues: TStrings;
    procedure FormToTeamList(ResultTeamList: TStrings);
    procedure TeamListToForm(Team60kmList: TStrings);
    procedure TeamListFromData(TeamList: TStrings; PlanData: TPlanData);
  public
    procedure setPanel(PanelMain: TPanel); override;
    procedure DataToForm(); override;
    procedure FormToData(); override;
    procedure toDefault(); override;
    function  isDefault(): boolean; override;
  end;


implementation

{$R *.dfm}



{ TDialogPanelFreeDays }

procedure TDialogPanel60kmDetail.DataToForm;
var
  Team60kmNames: TStrings;
begin
  Team60kmNames := TStringList.Create;
  TeamListFromData(Team60kmNames, PlanData);
  TeamListToForm(Team60kmNames);
  Team60kmNames.Free;
end;


procedure TDialogPanel60kmDetail.TeamListFromData(TeamList: TStrings; PlanData: TPlanData);
var
  TeamNode: TDataObject;
  TeamGegner: TDataObject;
  AllTeams: TStrings;
  i: integer;
begin
  TeamList.Clear;

  for TeamNode in PlanData.root.NamedChilds(nTeam) do
  begin
    if TeamNode.GetAsString(aTeamName) = TeamName then
    begin
      for TeamGegner in TeamNode.NamedChilds(nNoWeekGames) do
      begin
        TeamList.Add(TeamGegner.GetAsString(aTeamName));
      end;
    end;
  end;

  AllTeams := TStringList.Create;
  PlanData.getTeamNames(AllTeams);

  // Ungltige Teams entfernen
  for i := TeamList.Count-1 downto 0 do
  begin
    if 0 > AllTeams.IndexOf(TeamList[i]) then
    begin
      TeamList.Delete(i);
    end;
  end;

  AllTeams.Free;
end;


procedure TDialogPanel60kmDetail.TeamListToForm(Team60kmList: TStrings);
var
  AllTeams: TStrings;
  S: String;
begin
  AllTeams := TStringList.Create;

  PlanData.getTeamNames(AllTeams);

  ListViewTeams.Items.Clear;

  for S in AllTeams do
  begin
    if S <> TeamName then
    begin
      ListViewTeams.AddItem(S, nil);

      if 0 <= Team60kmList.IndexOf(S) then
      begin
        ListViewTeams.Items[ListViewTeams.Items.Count-1].Checked := True;
      end;
    end;
  end;
  AllTeams.Free;
end;


procedure TDialogPanel60kmDetail.FormCreate(Sender: TObject);
begin
  DefaultValues := TStringList.Create;
  FixControls(Self);
end;

procedure TDialogPanel60kmDetail.FormDestroy(Sender: TObject);
begin
  DefaultValues.Free;
end;

procedure TDialogPanel60kmDetail.FormToData;
var
  TeamList: TStrings;
  S: String;
  NewElem: TDataObject;
  TeamNode: TDataObject;
begin
  for TeamNode in PlanData.root.NamedChilds(nTeam) do
  begin
    if TeamNode.GetAsString(aTeamName) = TeamName then
    begin
      TeamNode.deleteChilds(nNoWeekGames);

      TeamList := TStringList.Create;
      FormToTeamList(TeamList);

      for S in TeamList do
      begin
        NewElem := TDataObject.Create(nNoWeekGames, TeamNode);
        NewElem.SetAsString(aTeamName, S);
      end;
      TeamList.Free;
    end;
  end;
end;


procedure TDialogPanel60kmDetail.FormToTeamList(ResultTeamList: TStrings);
var
  i: integer;
begin
  ResultTeamList.Clear;
  for i := 0 to ListViewTeams.Items.Count - 1 do
  begin
    if ListViewTeams.Items[i].Checked then
    begin
      ResultTeamList.Add(ListViewTeams.Items[i].Caption);
    end;
  end;
end;


function TDialogPanel60kmDetail.isDefault: boolean;
var
  TeamList1, TeamList2: TStrings;
  S: String;
begin
  TeamList1 := TStringList.Create;
  TeamList2 := TStringList.Create;

  if Assigned(PlanDataDefault) then
  begin
    TeamListFromData(TeamList1, PlanDataDefault);
  end;

  FormToData();

  TeamListFromData(TeamList2, PlanData);

  Result := TeamList1.Count = TeamList2.Count;

  for S in TeamList1 do
  begin
    if 0 > TeamList2.IndexOf(S) then
    begin
      Result := False;
    end;
  end;

  TeamList1.Free;
  TeamList2.Free;
end;

procedure TDialogPanel60kmDetail.ListViewTeamsClick(Sender: TObject);
begin
  FireOnChange();
end;

procedure TDialogPanel60kmDetail.setPanel(PanelMain: TPanel);
begin
  Self.PanelMain.Parent := PanelMain;
end;

procedure TDialogPanel60kmDetail.toDefault;
var
  TeamList: TStrings;
begin
  TeamList := TStringList.Create;

  if Assigned(PlanDataDefault) then
  begin
    TeamListFromData(TeamList, PlanDataDefault);
  end;

  TeamListToForm(TeamList);

  TeamList.Free;
end;

end.
