unit DialogPanel;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, Vcl.Menus, PlanDataObjects;

type

  TDialogPanelClass = class of TDialogPanel;

  TDialogPanel = class(TForm)
  private
    FOnChange: TNotifyEvent;
  protected
    procedure FireOnChange();
  public
    PlanData: TPlanData;
    PlanDataDefault: TPlanData;
    procedure setPanel(PanelMain: TPanel); virtual; abstract;
    procedure setPlanData(PlanData: TPlanData; PlanDataDefault: TPlanData);
    procedure DataToForm(); virtual; abstract;
    procedure FormToData(); virtual; abstract;
    procedure toDefault(); virtual; abstract;
    function  isDefault(): boolean; virtual; abstract;
    function  CheckData(): boolean; virtual;

    property OnChange: TNotifyEvent read FOnChange write FOnChange;
  end;


implementation


{ TDialogPanel }

function TDialogPanel.CheckData: boolean;
begin
  Result := True;
end;

procedure TDialogPanel.FireOnChange;
begin
  if Assigned(FOnChange) then
  begin
    FOnChange(Self);
  end;
end;

procedure TDialogPanel.setPlanData(PlanData: TPlanData; PlanDataDefault: TPlanData);
begin
  Self.PlanData := PlanData;
  Self.PlanDataDefault := PlanDataDefault;
end;

end.
