unit DialogForSinglePanel;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, Vcl.Menus, DialogPanel, PlanDataObjects;

type

  TDialogForSinglePanel = class(TForm)
    ButtonOK: TButton;
    PanelBottom: TPanel;
    ButtonToStandard: TButton;
    ButtonCancel: TButton;
    PanelMain: TPanel;
    procedure ButtonOKClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ButtonCancelClick(Sender: TObject);
    procedure ButtonToStandardClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    PlanData: TPlanData;
    DialogPanel: TDialogPanel;
    procedure DoOnDialogPanelChanged(Sender: TObject);
    procedure EnableButtons();
  public
    procedure SetValues(SourcePlan: TPlanData; PlanDataDefault: TPlanData; PanelClass: TDialogPanelClass);
    function getPlanData(): TPlanData;
  end;


implementation

{$R *.dfm}




procedure TDialogForSinglePanel.ButtonCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TDialogForSinglePanel.ButtonOKClick(Sender: TObject);
begin
  DialogPanel.FormToData();
  ModalResult := mrOk;
end;



procedure TDialogForSinglePanel.ButtonToStandardClick(Sender: TObject);
begin
  DialogPanel.toDefault();
  EnableButtons;
end;

procedure TDialogForSinglePanel.DoOnDialogPanelChanged(Sender: TObject);
begin
  EnableButtons();
end;

procedure TDialogForSinglePanel.EnableButtons;
begin
  ButtonToStandard.Enabled := not DialogPanel.isDefault;
end;

procedure TDialogForSinglePanel.FormCreate(Sender: TObject);
begin
  FixControls(Self);
end;

procedure TDialogForSinglePanel.FormDestroy(Sender: TObject);
begin
  PlanData.Free;
end;



function TDialogForSinglePanel.getPlanData: TPlanData;
begin
  Result := PlanData;
end;

procedure TDialogForSinglePanel.SetValues(SourcePlan: TPlanData; PlanDataDefault: TPlanData; PanelClass: TDialogPanelClass);
begin
  PlanData := TPlanData.Create();
  PlanData.Assign(SourcePlan);

  DialogPanel := PanelClass.Create(Self);
  DialogPanel.setPanel(PanelMain);
  DialogPanel.setPlanData(PlanData, PlanDataDefault);
  DialogPanel.DataToForm();
  Caption := DialogPanel.Caption;
  DialogPanel.OnChange := DoOnDialogPanelChanged;
  EnableButtons();

end;

end.
