unit DialogForSingleGewichtungsOptions;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, Vcl.Menus, DialogPanel, DialogPanelOptionArray;

type

  TDialogForSingleGewichtungsOptions = class(TForm)
    ButtonOK: TButton;
    PanelBottom: TPanel;
    ButtonToStandard: TButton;
    ButtonCancel: TButton;
    PanelMiddle: TPanel;
    Panel1: TPanel;
    LabelTitle: TLabel;
    PanelMessages: TPanel;
    Panel3: TPanel;
    MemoMessages: TMemo;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel2: TPanel;
    Label2: TLabel;
    PanelSpacer: TPanel;
    PanelMain: TPanel;
    procedure ButtonOKClick(Sender: TObject);
    procedure ButtonCancelClick(Sender: TObject);
    procedure ButtonToStandardClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    PanelPlanOptions: TFormPanelOptionArray;
    procedure EnableButtons();
    procedure ControlChanged(Sender: TObject);
    procedure SetShowButtons(const Value: boolean);
    function GetShowButtons: boolean;
    function GetOnButtonClick: TOptionButtonClick;
    procedure SetOnButtonClick(const Value: TOptionButtonClick);
  public
    procedure Init(titles: TStrings);
    procedure SetValues(values: TList<TCalculateOptionsValues>);
    procedure GetValues(values: TList<TCalculateOptionsValues>);
    procedure SetVisibleState(values: TList<boolean>);
    procedure SetTitle(value: String);
    procedure SetMessages(values: TStrings);
    procedure SmallDlg();
    property  ShowButtons: boolean read GetShowButtons write SetShowButtons;
    property  OnButtonClick: TOptionButtonClick read GetOnButtonClick write SetOnButtonClick;
  end;


implementation

{$R *.dfm}




procedure TDialogForSingleGewichtungsOptions.ButtonCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TDialogForSingleGewichtungsOptions.ButtonOKClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;



procedure TDialogForSingleGewichtungsOptions.ButtonToStandardClick(Sender: TObject);
begin
  PanelPlanOptions.toDefault();
  EnableButtons;
end;

procedure TDialogForSingleGewichtungsOptions.EnableButtons;
begin
  ButtonToStandard.Enabled := not PanelPlanOptions.isDefault;
end;

procedure TDialogForSingleGewichtungsOptions.FormCreate(Sender: TObject);
begin
  PanelPlanOptions := TFormPanelOptionArray.Create(Self);
  PanelPlanOptions.SetPanel(PanelMain);
  PanelPlanOptions.OnChanged := ControlChanged;
  FixControls(Self);
end;

function TDialogForSingleGewichtungsOptions.GetOnButtonClick: TOptionButtonClick;
begin
  Result := PanelPlanOptions.OnButtonClick;
end;

function TDialogForSingleGewichtungsOptions.GetShowButtons: boolean;
begin
  Result := PanelPlanOptions.ShowButtons;
end;

procedure TDialogForSingleGewichtungsOptions.GetValues(
  values: TList<TCalculateOptionsValues>);
begin
  PanelPlanOptions.GetValues(values);
end;

procedure TDialogForSingleGewichtungsOptions.Init(titles: TStrings);
begin
  PanelPlanOptions.Init(titles);
  EnableButtons();
end;

procedure TDialogForSingleGewichtungsOptions.SetMessages(values: TStrings);
begin
  PanelMessages.Visible := true;
  MemoMessages.Lines := values;

  Height := MulDiv(Width, 2, 3);
end;

procedure TDialogForSingleGewichtungsOptions.SetOnButtonClick(
  const Value: TOptionButtonClick);
begin
  PanelPlanOptions.OnButtonClick := Value;
end;

procedure TDialogForSingleGewichtungsOptions.SetShowButtons(const Value: boolean);
begin
  PanelPlanOptions.ShowButtons := Value;
end;

procedure TDialogForSingleGewichtungsOptions.SetTitle(value: String);
begin
  LabelTitle.Caption := value;
  Caption := value;
end;

procedure TDialogForSingleGewichtungsOptions.SetValues(values: TList<TCalculateOptionsValues>);
begin
  PanelPlanOptions.SetValues(values);
  EnableButtons();
end;

procedure TDialogForSingleGewichtungsOptions.SetVisibleState(values: TList<boolean>);
begin
  PanelPlanOptions.SetVisibleState(values);
  EnableButtons();
end;

procedure TDialogForSingleGewichtungsOptions.SmallDlg;
begin
  Height := Width div 2;
end;

procedure TDialogForSingleGewichtungsOptions.ControlChanged(Sender: TObject);
begin
  EnableButtons();
end;


end.
