unit DialogForMultiplePanel;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, Vcl.Menus, DialogPanel, PlanDataObjects;

type

  TDialogForMultiplePanel = class(TForm)
    ButtonOK: TButton;
    PanelBottom: TPanel;
    ButtonToStandard: TButton;
    ButtonCancel: TButton;
    PanelMain: TPanel;
    TreeView: TTreeView;
    procedure ButtonOKClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ButtonCancelClick(Sender: TObject);
    procedure ButtonToStandardClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TreeViewChange(Sender: TObject; Node: TTreeNode);
    procedure TreeViewChanging(Sender: TObject; Node: TTreeNode;
      var AllowChange: Boolean);
  private
    DialogClasses: TList<TDialogPanelClass>;
    PlanData: TPlanData;
    PlanDataDefault: TPlanData;
    DialogPanel: TDialogPanel;
    procedure DoOnDialogPanelChanged(Sender: TObject);
    procedure EnableButtons();
    procedure ChangePanel(PanelClass: TDialogPanelClass);
  public
    procedure SetValues(SourcePlan: TPlanData; PlanDataDefault: TPlanData; PanelClasses: array of TDialogPanelClass);
    function getPlanData(): TPlanData;
  end;


implementation

{$R *.dfm}




procedure TDialogForMultiplePanel.ButtonCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TDialogForMultiplePanel.ButtonOKClick(Sender: TObject);
begin
  if DialogPanel.CheckData() then
  begin
    DialogPanel.FormToData();
    ModalResult := mrOk;
  end;
end;



procedure TDialogForMultiplePanel.ButtonToStandardClick(Sender: TObject);
begin
  DialogPanel.toDefault();
  EnableButtons;
end;

procedure TDialogForMultiplePanel.DoOnDialogPanelChanged(Sender: TObject);
begin
  EnableButtons();
end;

procedure TDialogForMultiplePanel.EnableButtons;
begin
  ButtonToStandard.Visible := Assigned(PlanDataDefault);
  if ButtonToStandard.Visible then
  begin
    ButtonToStandard.Enabled := not DialogPanel.isDefault;
  end
end;

procedure TDialogForMultiplePanel.FormCreate(Sender: TObject);
begin
  FixFormSize(Self, 1200, 800);
  PlanData := TPlanData.Create();
  DialogClasses := TList<TDialogPanelClass>.Create;
  FixControls(Self);
end;

procedure TDialogForMultiplePanel.FormDestroy(Sender: TObject);
begin
  DialogClasses.Free;
  PlanData.Free;
end;



function TDialogForMultiplePanel.getPlanData: TPlanData;
begin
  Result := PlanData;
end;

procedure TDialogForMultiplePanel.SetValues(SourcePlan: TPlanData; PlanDataDefault: TPlanData; PanelClasses: array of TDialogPanelClass);
var
  PanelClass: TDialogPanelClass;
  TempPanel: TDialogPanel;
  Node: TTreeNode;
  isFirst: boolean;
begin
  PlanData.Assign(SourcePlan);
  Self.PlanDataDefault := PlanDataDefault;

  DialogClasses.Clear;
  TreeView.Items.Clear;

  isFirst := true;

  for PanelClass in PanelClasses do
  begin
    TempPanel := PanelClass.Create(Self);

    DialogClasses.Add(PanelClass);
    Node := TreeView.Items.AddChild(nil, TempPanel.Caption);
    Node.Data := PanelClass;

    if isFirst then
    begin
      // Selected fhrt auch OnChangeItem aus
      Node.Selected := true;
      isFirst := False;
    end;

    TempPanel.Free;
  end;
end;

procedure TDialogForMultiplePanel.TreeViewChange(Sender: TObject;
  Node: TTreeNode);
begin
  if not (csDestroying in ComponentState) then
  begin
    if Assigned(node.Data) then
    begin
      ChangePanel(TDialogPanelClass(node.Data));
    end;
  end;
end;

procedure TDialogForMultiplePanel.TreeViewChanging(Sender: TObject; Node: TTreeNode; var AllowChange: Boolean);
begin
  AllowChange := True;
  if not (csDestroying in ComponentState) then
  begin
    if Assigned(DialogPanel) then
    begin
      if not DialogPanel.CheckData() then
      begin
        AllowChange := False;
      end;
    end;
  end;
end;

procedure TDialogForMultiplePanel.ChangePanel(PanelClass: TDialogPanelClass);
begin
  if Assigned(DialogPanel) then
  begin
    DialogPanel.FormToData();
    FreeAndNil(DialogPanel);
  end;

  DialogPanel := PanelClass.Create(Self);
  DialogPanel.setPanel(PanelMain);
  DialogPanel.setPlanData(PlanData, PlanDataDefault);
  DialogPanel.DataToForm();
  DialogPanel.OnChange := DoOnDialogPanelChanged;
  EnableButtons();


end;

end.
