unit DialogFirstStart;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  System.UITypes, Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ComCtrls, PlanTypes,
  Vcl.ExtCtrls, Vcl.Grids, PlanUtils, Vcl.Samples.Spin, DialogPanelHomeDaysDetail, PlanDataObjects,
  DialogForSinglePanel, DialogPanel, DialogPanelLocationsCompact, DialogPanelHomeCoupleCompact,
  DialogPanelAuswaertskoppel, DialogPanelRanking, DialogPanelMandatoryDays, DialogPanelHomeDays;

type

  TMessages = (tmLocations, tmKoppel, tmAuswaertskoppel, tmSetzliste, tmMandatoryDays);

  TDialogFirstStart = class(TForm)
    PanelBottom: TPanel;
    ButtonOK: TButton;
    ButtonCancel: TButton;
    PanelTop: TPanel;
    LabelMessage: TLabel;
    LabelHeader: TLabel;
    procedure ButtonCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonOKClick(Sender: TObject);
  private
    { Private-Deklarationen }
    CurrMessage: TMessages;
    PlanData: TPlanData;
    PlanDataDefault: TPlanData;
    PlanLoaded: TPlan;
    procedure UpdateTexts;
    procedure NextMessage();
    function HasData(MessageType: TMessages): boolean;
    function StartAction(PanelClass: TDialogPanelClass): boolean;
  public
    { Public-Deklarationen }
    procedure SetValue(PlanData: TPlanData; PlanDataDefault: TPlanData; PlanLoaded: TPlan);
  end;


implementation

{$R *.dfm}

uses
  AndiGeneratorMain;

procedure TDialogFirstStart.ButtonCancelClick(Sender: TObject);
begin
  NextMessage();
end;


procedure TDialogFirstStart.UpdateTexts();
begin
  case CurrMessage of
    tmLocations:
      begin
        LabelHeader.Caption := 'Spiellokale';
        LabelMessage.Caption := 'Die Spiellokale werden von Click-TT ber die Schnittstelle nicht bertragen.'
                                + cNewLine + cNewLine + 'Falls Sie Vereine mit mehreren Spiellokalen in Ihrer Runde haben, so mssen die Spiellokale bei den Mannschaften und Nachbarmannschaften angegeben werden, sonst liefert die Berechnung der Hallenbelegung fehlerhafte Ergebnisse.'
                                + cNewLine + cNewLine + 'Falls alle Vereine nur ein Spiellokal haben, so kann dieser Punkt bersprungen werden.'
                                + cNewLine + 'Falls die Vereine keine Beschrnkung bei der Anzahl der Heimspiele angegeben haben, so kann der Punkt ebenfalls bersprungen werden.';
        ButtonOK.Caption := 'Spiellokale bearbeiten'
      end;
    tmKoppel:
      begin
        LabelHeader.Caption := 'Koppeltermine';
        LabelMessage.Caption := 'Der Plan enthlt Koppelwnsche oder mgliche Doppelspieltage.'
                                + cNewLine + cNewLine + 'Alle mglichen Optionen knnen in Click-TT nicht eingegeben werden und die Mannschaften machen hier auch gerne mal Eingabefehler.'
                                + cNewLine + cNewLine + 'Bitte berprfen Sie die Eingaben der Mannschaften.';
        ButtonOK.Caption := 'Koppeltermine bearbeiten'
      end;
    tmAuswaertskoppel:
      begin
        LabelHeader.Caption := 'Auswrtskoppelwnsche';
        LabelMessage.Caption := 'Der Plan enthlt Auswrtskoppelwnsche.'
                                + cNewLine + cNewLine + 'Alle mglichen Optionen knnen in Click-TT nicht eingegeben werden und die Mannschaften machen hier auch gerne mal Eingabefehler.'
                                + cNewLine + cNewLine + 'Bitte berprfen Sie die Eingaben der Mannschaften.';
        ButtonOK.Caption := 'Auswrtskoppelwnsche bearbeiten'
      end;
    tmSetzliste:
      begin
        LabelHeader.Caption := 'Setzliste';
        LabelMessage.Caption := 'Mit der Setzliste knnen Sie die erwartete Tabelle am Ende der Saison vorgeben.'
                                + cNewLine + cNewLine + 'Das Ziel ist, dass am Ende der Saison die strksten und schwchsten Mannschaften gegeneinander spielen sollen. Damit soll verhindert werden, dass in den wichtigen Spielen'
                                + ' um den Auf- und Abstieg Mannschaften beteiligt sind, bei denen es um nichts mehr geht.'
                                + cNewLine + cNewLine + 'Mit der Setzliste soll die Spannung bis zum Schluss erhalten bleiben und, falls es so etwas berhaupt geben sollte, Mauscheleien verhindert werden.';
        ButtonOK.Caption := 'Setzliste aktivieren'
      end;
    tmMandatoryDays:
      begin
        LabelHeader.Caption := 'Pflichtspieltage';
        LabelMessage.Caption := 'Der Plan enthlt Pflichtspieltage.'
                                + cNewLine + cNewLine + 'Pflichtspieltage sind vor allem bei Ligen mit ungerader Mannschaftszahl problematisch. In diesem Fall msste eine Mannschaft in einer Woche zwei Spiele machen. '
                                + 'Um das zu verhindern sollte der Zeitraums des Pflichtspiels verlngert werden oder am Besten die Pflichtspieltage gelscht werden und stattdessen sollte der letzte Spieltag optimiert werden.'
                                + cNewLine + cNewLine + 'Bitte Bearbeiten Sie die Pflichtspieltage.';
        ButtonOK.Caption := 'Pflichtspieltage bearbeiten'
      end;

  end;
end;

function TDialogFirstStart.StartAction(PanelClass: TDialogPanelClass): boolean;
var
  Form: TDialogForSinglePanel;
begin
  Result := False;
  Form := TDialogForSinglePanel.Create(Self);
  Form.SetValues(PlanData, PlanDataDefault, PanelClass);

  if mrOk = Form.ShowModal then
  begin
    PlanData.Assign(Form.getPlanData());
    DoAfterMainPlanChanged(false);
    Result := True;
  end;
  Form.Free;
end;


procedure TDialogFirstStart.ButtonOKClick(Sender: TObject);
var
  Erfolg: boolean;
begin
  Erfolg := False;
  case CurrMessage of
    tmLocations:
      Erfolg := StartAction(TDialogPanelLocationsCompact);
    tmKoppel:
      Erfolg := StartAction(TDialogPanelHomeCoupleCompact);
    tmAuswaertskoppel:
      Erfolg := StartAction(TDialogPanelAuswaertskoppel);
    tmSetzliste:
      Erfolg := StartAction(TDialogPanelRanking);
    tmMandatoryDays:
      Erfolg := StartAction(TDialogPanelMandatoryDays);
  end;
  if Erfolg then
  begin
    NextMessage();
  end;
end;

procedure TDialogFirstStart.FormCreate(Sender: TObject);
begin
  CurrMessage := tmLocations;
  UpdateTexts();
  FixControls(Self);
end;

function TDialogFirstStart.HasData(MessageType: TMessages): boolean;
begin
  Result := False;

  case MessageType of
    tmLocations:
          Result := True;
    tmKoppel:
          Result := PlanLoaded.HasPossibleKoppelTermine;
    tmAuswaertskoppel:
          Result := PlanLoaded.HasAuswaertsKoppelTermine;
    tmSetzliste:
          Result := True;
    tmMandatoryDays:
          Result := PlanLoaded.HasMandatoryGameDays;
  end;

end;


procedure TDialogFirstStart.NextMessage;
begin
  if CurrMessage = High(TMessages) then
  begin
    ModalResult := mrOk;
  end
  else
  begin
    CurrMessage := TMessages(Ord(CurrMessage) + 1);
    if not HasData(CurrMessage) then
    begin
      NextMessage;
    end
    else
    begin
      UpdateTexts();
    end;
  end;
end;

procedure TDialogFirstStart.SetValue(PlanData: TPlanData; PlanDataDefault: TPlanData; PlanLoaded: TPlan);
begin
  Self.PlanData := PlanData;
  Self.PlanDataDefault := PlanDataDefault;
  Self.PlanLoaded := PlanLoaded;
end;

end.
