unit DialogEditTeamName;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  System.UITypes, Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ComCtrls, PlanTypes,
  Vcl.ExtCtrls, Vcl.Grids, PlanUtils, Vcl.Samples.Spin, PlanDataObjects;

type
  TFormEditTeamName = class(TForm)
    Label1: TLabel;
    EditName: TEdit;
    EditId: TEdit;
    Label2: TLabel;
    PanelBottom: TPanel;
    ButtonOK: TButton;
    ButtonCancel: TButton;
    PanelTop: TPanel;
    EditClubId: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    EditNumber: TSpinEdit;
    Label5: TLabel;
    Label6: TLabel;
    ComboLocation: TComboBox;
    LabelKoppelPrio: TLabel;
    procedure ButtonCancelClick(Sender: TObject);
    procedure ButtonOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    procedure SetValues(PlanData: TPlanData; TeamName: String; TeamNumber: integer; TeamId, ClubId, Location: String);
    procedure GetValues(var TeamName: String; var TeamNumber: integer; var TeamId, ClubId, Location: String);
  end;


implementation

{$R *.dfm}

procedure TFormEditTeamName.ButtonCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TFormEditTeamName.ButtonOKClick(Sender: TObject);
begin
  if Trim(EditName.Text) = '' then
  begin
    ShowMessage('Der Mannschaftsname darf nicht leer sein');
    Exit;
  end;
  if Trim(EditId.Text) = '' then
  begin
    ShowMessage('Die Mannschafts-ID darf nicht leer sein');
    Exit;
  end;
  if Trim(EditClubId.Text) = '' then
  begin
    ShowMessage('Die Vereins-ID darf nicht leer sein');
    Exit;
  end;

  ModalResult := mrOk;
end;




procedure TFormEditTeamName.FormCreate(Sender: TObject);
begin
  FixControls(Self);
end;

procedure TFormEditTeamName.GetValues(var TeamName: String; var TeamNumber: integer; var TeamId, ClubId, Location: String);
begin
  TeamName := Trim(EditName.Text);
  TeamId := Trim(EditId.Text);
  TeamNumber := EditNumber.Value;
  ClubId := Trim(EditClubId.Text);
  Location := Trim(GetListComboValue(ComboLocation));
end;

procedure TFormEditTeamName.SetValues(PlanData: TPlanData; TeamName: String; TeamNumber: integer; TeamId, ClubId, Location: String);
begin
  EditName.Text := TeamName;
  EditId.Text := TeamId;
  EditNumber.Value := TeamNumber;
  EditClubId.Text := ClubId;
  PlanData.getTeamLocationsInt(ComboLocation.Items);
  SetListComboValue(ComboLocation, Location);
end;

end.
