unit DialogEditSisterTeam;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, PlanTypes, PlanUtils,
  Vcl.ComCtrls, System.Generics.Collections, System.Generics.Defaults,
  Vcl.Grids, Vcl.ValEdit, EditMandatoryDatesDialog, Vcl.Menus, DialogPanelOptionArray, DialogForSingleGewichtungsOptions,
  DialogPanel, PlanDataObjects, DialogEditTeamName, System.UITypes, Math, DialogEditOneSisterGame,
  Vcl.Samples.Spin;

type
  TDialogEditSisterTeam = class(TForm)
    PanelMain: TPanel;
    PanelClient: TPanel;
    ButtonGameDelete: TButton;
    ButtonGameEdit: TButton;
    ButtonGameNew: TButton;
    Label1: TLabel;
    PanelTop: TPanel;
    PanelRight: TPanel;
    Grid: TStringGrid;
    PanelBottom: TPanel;
    ButtonOK: TButton;
    ButtonCancel: TButton;
    Panel1: TPanel;
    Label2: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    EditName: TEdit;
    EditNumber: TSpinEdit;
    Label3: TLabel;
    ComboBoxArt: TComboBox;
    Label4: TLabel;
    ComboLocation: TComboBox;
    LabelKoppelPrio: TLabel;
    CheckBoxParallelGames: TCheckBox;
    CheckBoxParallelHomeGames: TCheckBox;
    procedure ButtonGameEditClick(Sender: TObject);
    procedure ButtonGameDeleteClick(Sender: TObject);
    procedure ListBoxTeamsClick(Sender: TObject);
    procedure ButtonGameNewClick(Sender: TObject);
    procedure GridClick(Sender: TObject);
    procedure GridDblClick(Sender: TObject);
    procedure ButtonCancelClick(Sender: TObject);
    procedure ButtonOKClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure EditNameChange(Sender: TObject);
    procedure ComboLocationChange(Sender: TObject);
  private
    SisterTeamNode: TDataObject;
    MainTeamName: String;
    OldSisterTeamName: String;
    PlanData: TPlanData;
    procedure EnableButtons();
    procedure SortGrid;
    function getSelectedGameNode: TDataObject;
    procedure DataToGrid;
  public
    procedure SetValues(SisterTeamNode: TDataObject; PlanData: TPlanData; MainTeamName: String);
    procedure GetValues(SisterTeamNode: TDataObject);
    procedure DataToForm();
    procedure FormToData();
  end;


implementation

{$R *.dfm}




procedure TDialogEditSisterTeam.SetValues(SisterTeamNode: TDataObject; PlanData: TPlanData; MainTeamName: String);
begin
  Self.SisterTeamNode.Clear;
  OldSisterTeamName := '';
  if Assigned(SisterTeamNode) then
  begin
    Self.SisterTeamNode.assign(SisterTeamNode);
    OldSisterTeamName := SisterTeamNode.GetAsString(aTeamName);
  end;
  Self.MainTeamName := MainTeamName;
  Self.PlanData := PlanData;
  PlanData.getTeamLocationsInt(ComboLocation.Items);
  DataToForm();
end;

procedure TDialogEditSisterTeam.SortGrid();
var
  row: Integer;
  Date1, Date2: TDateTime;
  col: Integer;
  S: String;
begin
  row := 1;
  while row <= grid.RowCount-2 do
  begin
    Date1 := DateFromString(Grid.Cells[0, row]) + TimeFromString(Grid.Cells[1, row]);
    Date2 := DateFromString(Grid.Cells[0, row+1]) + TimeFromString(Grid.Cells[1, row+1]);

    if Date1 > Date2 then
    begin
      for col := 0 to grid.ColCount-1 do
      begin
        S := Grid.Cells[col, row];
        Grid.Cells[col, row] := Grid.Cells[col, row+1];
        Grid.Cells[col, row+1] := S;
      end;
      row := 1;
    end
    else
    begin
      Inc(row);
    end;
  end;
end;


procedure TDialogEditSisterTeam.DataToGrid;
var
  GameNode: TDataObject;
  col: Integer;
  row: integer;
  OldRow: integer;
  GameDate: TDateTime;
  HomeTeamName, GuestTeamName: String;
  Location: String;
begin
  OldRow := Grid.Row;
  Grid.RowCount := 2;
  Grid.Cells[0, 0] := 'Datum';
  Grid.Cells[1, 0] := 'Uhrzeit';
  Grid.Cells[2, 0] := 'Heimmannschaft';
  Grid.Cells[3, 0] := 'Gastmannschaft';
  Grid.Cells[4, 0] := 'Spiellokal';

  Grid.ColWidths[0] := 100;
  Grid.ColWidths[1] := 80;
  Grid.ColWidths[2] := 200;
  Grid.ColWidths[3] := 200;
  Grid.ColWidths[4] := 200;

  for col := 0 to Grid.ColCount-1 do
  begin
    Grid.Cells[col, 1] := '';
  end;

  row := 1;

  for GameNode in SisterTeamNode.NamedChilds(nSisterGame) do
  begin
    Grid.RowCount := max(2, row + 1);

    GameDate := GameNode.GetAsDateTime(aDateTime);

    Grid.Cells[0, row] := DateToString(Trunc(GameDate));
    Grid.Cells[1, row] := TimeToString(FixDateTime(GameDate - Trunc(GameDate)));

    HomeTeamName := GameNode.GetAsString(aHomeTeamName);
    if OldSisterTeamName = HomeTeamName then
    begin
      HomeTeamName := Trim(EditName.Text);
    end;

    GuestTeamName := GameNode.GetAsString(aGuestTeamName);
    if OldSisterTeamName = GuestTeamName then
    begin
      GuestTeamName := Trim(EditName.Text);
    end;

    Grid.Cells[2, row] := HomeTeamName;
    Grid.Cells[3, row] := GuestTeamName;

    Location := '';
    if HomeTeamName = Trim(EditName.Text) then
    begin
      Location := GetListComboValue(ComboLocation);
    end;

    if PlanData.FixLocation(GameNode.GetAsString(aLocation)) <> '' then
    begin
      Location := PlanData.FixLocation(GameNode.GetAsString(aLocation));
    end;

    Grid.Cells[4, row] := Location;

    Inc(row);
  end;
  SortGrid();

  if OldRow > 0 then
  begin
    Grid.Row := OldRow;
  end;
end;


procedure TDialogEditSisterTeam.DataToForm;
begin
  EditName.Text := SisterTeamNode.GetAsString(aTeamName);
  EditNumber.Value := SisterTeamNode.GetAsInt(aTeamNumber);
  ComboBoxArt.Text := SisterTeamNode.GetAsString(aGender);
  SetListComboValue(ComboLocation, SisterTeamNode.GetAsString(aLocation));
  CheckBoxParallelGames.Checked := SisterTeamNode.GetAsBool(aNoParallelGames);
  CheckBoxParallelHomeGames.Checked := SisterTeamNode.GetAsBool(aParallelHomeGames);

  DataToGrid();

  EnableButtons();
end;


procedure TDialogEditSisterTeam.EditNameChange(Sender: TObject);
begin
  DataToGrid();
end;

procedure TDialogEditSisterTeam.EnableButtons;
begin
  ButtonGameDelete.Enabled := Assigned(getSelectedGameNode());
  ButtonGameEdit.Enabled := ButtonGameDelete.Enabled;
end;


function TDialogEditSisterTeam.getSelectedGameNode(): TDataObject;
var
  GameNode: TDataObject;
  GameDate: TDateTime;
  HomeTeamName, GuestTeamName: String;
begin
  Result := nil;

  if Grid.Row > 0 then
  begin
    for GameNode in SisterTeamNode.NamedChilds(nSisterGame) do
    begin
      HomeTeamName := GameNode.GetAsString(aHomeTeamName);
      if OldSisterTeamName = HomeTeamName then
      begin
        HomeTeamName := Trim(EditName.Text);
      end;

      GuestTeamName := GameNode.GetAsString(aGuestTeamName);
      if OldSisterTeamName = GuestTeamName then
      begin
        GuestTeamName := Trim(EditName.Text);
      end;

      GameDate := GameNode.GetAsDateTime(aDateTime);
      if (Grid.Cells[0, Grid.row] = DateToString(Trunc(GameDate)))
          and (Grid.Cells[1, Grid.row] = TimeToString(FixDateTime(GameDate - Trunc(GameDate))))
          and (Grid.Cells[2, Grid.row] = HomeTeamName)
          and (Grid.Cells[3, Grid.row] = GuestTeamName) then
      begin
        Result := GameNode;
      end;
    end;
  end;
end;


procedure TDialogEditSisterTeam.ButtonCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TDialogEditSisterTeam.ButtonGameDeleteClick(Sender: TObject);
var
  GameNode: TDataObject;
begin
  GameNode := getSelectedGameNode();

  if Assigned(GameNode) then
  begin
    if mrYes = MessageDlg('Mchten Sie das Spiel wirklich lschen?', mtConfirmation, [mbYes, mbNo], 0) then
    begin
      SisterTeamNode.RemoveChild(GameNode);
      DataToGrid();
    end;
  end;
end;

procedure TDialogEditSisterTeam.ButtonGameEditClick(Sender: TObject);
var
  Dialog: TDialogEditOneSisterGame;
  GameNode: TDataObject;
begin
  GameNode := getSelectedGameNode();

  if Assigned(GameNode) then
  begin
    Dialog := TDialogEditOneSisterGame.Create(Self);
    Dialog.SetValue(PlanData, GameNode, Trim(EditName.Text), MainTeamName);

    if mrOk = Dialog.ShowModal then
    begin
      Dialog.GetValue(GameNode);
      DataToGrid;
    end;
    Dialog.Free;
  end;
end;



procedure TDialogEditSisterTeam.ButtonGameNewClick(Sender: TObject);
var
  Dialog: TDialogEditOneSisterGame;
  GameNode: TDataObject;
begin
  Dialog := TDialogEditOneSisterGame.Create(Self);
  Dialog.SetValue(PlanData, nil, Trim(EditName.Text), MainTeamName);

  if mrOk = Dialog.ShowModal then
  begin
    GameNode := TDataObject.Create(nSisterGame, SisterTeamNode);
    Dialog.GetValue(GameNode);
    DataToGrid;
  end;
  Dialog.Free;
end;

procedure TDialogEditSisterTeam.ButtonOKClick(Sender: TObject);
begin
  if Trim(EditName.Text) = '' then
  begin
    ShowMessage('Der Name darf nicht leer sein');
  end
  else
  if Trim(ComboBoxArt.Text) = '' then
  begin
    ShowMessage('Die Art darf nicht leer sein');
  end
  else
  begin
    ModalResult := mrOK;
  end;
end;

procedure TDialogEditSisterTeam.ComboLocationChange(Sender: TObject);
begin
  DataToGrid();
end;

procedure TDialogEditSisterTeam.FormCreate(Sender: TObject);
begin
  SisterTeamNode := TDataObject.Create(nSisterTeam, nil);

  GetGenderList(ComboBoxArt.Items);

  FixControls(Self);
end;

procedure TDialogEditSisterTeam.FormDestroy(Sender: TObject);
begin
  SisterTeamNode.Free;
end;

procedure TDialogEditSisterTeam.FormToData;
begin
end;

procedure TDialogEditSisterTeam.GetValues(SisterTeamNode: TDataObject);
var
  GameNode: TDataObject;
begin
  Self.SisterTeamNode.SetAsString(aTeamName, Trim(EditName.Text));
  Self.SisterTeamNode.SetAsInt(aTeamNumber, EditNumber.Value);
  Self.SisterTeamNode.SetAsString(aGender, ComboBoxArt.Text);
  Self.SisterTeamNode.SetAsString(aLocation, GetListComboValue(ComboLocation));
  Self.SisterTeamNode.SetAsBool(aNoParallelGames, CheckBoxParallelGames.Checked);
  Self.SisterTeamNode.SetAsBool(aParallelHomeGames, CheckBoxParallelHomeGames.Checked);

  for GameNode in Self.SisterTeamNode.NamedChilds(nSisterGame) do
  begin
    if GameNode.GetAsString(aHomeTeamName) = OldSisterTeamName then
    begin
      GameNode.SetAsString(aHomeTeamName, Trim(EditName.Text));
    end;
    if GameNode.GetAsString(aGuestTeamName) = OldSisterTeamName then
    begin
      GameNode.SetAsString(aGuestTeamName, Trim(EditName.Text));
    end;
  end;


  SisterTeamNode.assign(Self.SisterTeamNode);
end;

procedure TDialogEditSisterTeam.GridClick(Sender: TObject);
begin
  EnableButtons();
end;

procedure TDialogEditSisterTeam.GridDblClick(Sender: TObject);
begin
  if Assigned(getSelectedGameNode()) then
  begin
    ButtonGameEditClick(nil);
  end;
end;


procedure TDialogEditSisterTeam.ListBoxTeamsClick(Sender: TObject);
begin
  EnableButtons();
end;


end.
