unit DialogEditOneSisterGame;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  System.UITypes, Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ComCtrls, PlanTypes,
  Vcl.ExtCtrls, Vcl.Grids, PlanUtils, PlanDataObjects;

type
  TDialogEditOneSisterGame = class(TForm)
    PanelBottom: TPanel;
    ButtonOK: TButton;
    ButtonCancel: TButton;
    PanelHomeDayData: TPanel;
    TimePicker: TDateTimePicker;
    Label4: TLabel;
    Label1: TLabel;
    ComboGameType: TComboBox;
    Label2: TLabel;
    ComboLocation: TComboBox;
    LabelKoppelPrio: TLabel;
    DatePicker: TDateTimePicker;
    Label3: TLabel;
    EditGegner: TEdit;
    Label5: TLabel;
    procedure ButtonCancelClick(Sender: TObject);
    procedure ButtonOKClick(Sender: TObject);
    procedure ComboGameTypeChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
    PlanData: TPlanData;
    SisterTeamName: String;
    procedure EnableButtons;
  public
    { Public-Deklarationen }
    procedure SetValue(PlanData: TPlanData; Value: TDataObject; SisterTeamName, MainTeamName: String);
    procedure GetValue(Value: TDataObject);
  end;


implementation

{$R *.dfm}

procedure TDialogEditOneSisterGame.ButtonCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TDialogEditOneSisterGame.ButtonOKClick(Sender: TObject);
begin
  if Trim(EditGegner.Text) = '' then
  begin
    ShowMessage('Kein Gegner angegeben');
  end
  else
  begin
    ModalResult := mrOk;
  end;
end;




procedure TDialogEditOneSisterGame.ComboGameTypeChange(Sender: TObject);
begin
  EnableButtons();
end;

procedure TDialogEditOneSisterGame.EnableButtons();
begin
end;




procedure TDialogEditOneSisterGame.FormCreate(Sender: TObject);
begin
  FixControls(Self);
end;

procedure TDialogEditOneSisterGame.GetValue(Value: TDataObject);
begin
  Value.SetAsDateTime(aDateTime, FixDateTime(Trunc(DatePicker.DateTime) + TimePicker.DateTime - Trunc(TimePicker.DateTime)));
  if ComboGameType.ItemIndex = 0 then
  begin
    Value.SetAsString(aHomeTeamName, SisterTeamName);
    Value.SetAsString(aGuestTeamName, EditGegner.Text);
  end
  else
  begin
    Value.SetAsString(aGuestTeamName, SisterTeamName);
    Value.SetAsString(aHomeTeamName, EditGegner.Text);
  end;

  Value.SetAsString(aLocation, GetListComboValue(ComboLocation));
end;

procedure TDialogEditOneSisterGame.SetValue(PlanData: TPlanData; Value: TDataObject; SisterTeamName, MainTeamName: String);
begin
  Self.PlanData := PlanData;

  DatePicker.DateTime := Trunc(PlanData.root.GetAsDate(aFrom));

  Self.SisterTeamName := SisterTeamName;

  PlanData.getTeamLocationsInt(ComboLocation.Items);

  if Assigned(Value) then
  begin
    DatePicker.DateTime := Trunc(Value.GetAsDateTime(aDateTime));
    TimePicker.DateTime := Value.GetAsDateTime(aDateTime) - Trunc(Value.GetAsDateTime(aDateTime));

    if Value.GetAsString(aHomeTeamName) = SisterTeamName then
    begin
      ComboGameType.ItemIndex := 0;
      EditGegner.Text := Value.GetAsString(aGuestTeamName);
    end
    else
    begin
      ComboGameType.ItemIndex := 1;
      EditGegner.Text := Value.GetAsString(aHomeTeamName);
    end;
    SetListComboValue(ComboLocation, Value.GetAsString(aLocation));
  end;
end;

end.
