unit DialogEditOneHomeDay;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  System.UITypes, Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ComCtrls, PlanTypes,
  Vcl.ExtCtrls, Vcl.Grids, PlanUtils, Vcl.Samples.Spin, DialogPanelHomeDaysDetail, PlanDataObjects;

type
  TDialogEditOneHomeDay = class(TForm)
    PanelBottom: TPanel;
    ButtonOK: TButton;
    ButtonCancel: TButton;
    PanelTop: TPanel;
    LabelDate: TLabel;
    ComboBox: TComboBox;
    PanelHomeDayData: TPanel;
    TimePicker: TDateTimePicker;
    Label4: TLabel;
    Label1: TLabel;
    ComboBoxMaxGames: TComboBox;
    ComboBoxKoppel: TComboBox;
    Label2: TLabel;
    ComboBoxPrio: TComboBox;
    LabelKoppelPrio: TLabel;
    TimePickerKoppelTime: TDateTimePicker;
    LabelKoppelSecondTime: TLabel;
    Label3: TLabel;
    CheckBoxAusweich: TCheckBox;
    TimePickerSecondTimeAuswaertskoppel: TDateTimePicker;
    LabelAuswaertsKoppelTime: TLabel;
    CheckBoxAuswaertskoppel: TCheckBox;
    LabelAuswaertsKoppel: TLabel;
    Label5: TLabel;
    ComboLocation: TComboBox;
    Label6: TLabel;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    procedure ButtonCancelClick(Sender: TObject);
    procedure ButtonOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ComboBoxChange(Sender: TObject);
    procedure ComboBoxKoppelChange(Sender: TObject);
    procedure ComboBoxPrioChange(Sender: TObject);
    procedure CheckBoxAuswaertskoppelClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Value: THomeDay;
    procedure EnableButtons;
    function CheckValueData: boolean;
  public
    { Public-Deklarationen }
    procedure SetValue(PlanData: TPlanData; TeamName: String; Value: THomeDay; Date: TDateTime);
    function  GetValue(): THomeDay;
  end;


implementation

{$R *.dfm}

procedure TDialogEditOneHomeDay.ButtonCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TDialogEditOneHomeDay.ButtonOKClick(Sender: TObject);
begin
  if ComboBox.ItemIndex = 0 then
  begin
    Value.NoDate := true;
    Value.SperrTermin := false;
  end;
  if ComboBox.ItemIndex = 2 then
  begin
    Value.NoDate := false;
    Value.SperrTermin := true;
  end;
  if ComboBox.ItemIndex = 1 then
  begin
    Value.NoDate := false;
    Value.SperrTermin := false;
    Value.Date := TimePicker.Time;
    Value.MaxParallelGame := ComboBoxMaxGames.ItemIndex;
    Value.AusweichTermin := CheckBoxAusweich.Checked;
    Value.Location := GetListComboValue(ComboLocation);
    Value.KoppelDate := False;
    Value.KoppelAuswaertsSecondTime := False;
    Value.DoubleDate := False;
    if ComboBoxKoppel.ItemIndex <> 0 then
    begin
      if ComboBoxKoppel.ItemIndex = 1 then
      begin
        Value.KoppelDate := True;
        Value.KoppelSecondTime := FixDateTime(TimePickerKoppelTime.Time - Trunc(TimePickerKoppelTime.Time));
      end;
      if ComboBoxKoppel.ItemIndex = 2 then
      begin
        Value.DoubleDate := True;
      end;
      Value.KoppelPrio := ComboBoxPrio.ItemIndex;
    end;

    if ComboBoxKoppel.ItemIndex <> 1 then
    begin
      if CheckBoxAuswaertskoppel.Checked then
      begin
        Value.KoppelAuswaertsSecondTime := True;
        Value.KoppelSecondTime := FixDateTime(TimePickerSecondTimeAuswaertskoppel.Time - Trunc(TimePickerSecondTimeAuswaertskoppel.Time));
      end;
    end;
  end;

  if CheckValueData() then
  begin
    ModalResult := mrOk;
  end;
end;


function TDialogEditOneHomeDay.CheckValueData(): boolean;
var
  HomeTime: TDateTime;
begin
  Result := True;

  if Value.IsHomeDay then
  begin
    HomeTime := FixDateTime(Value.Date - Trunc(Value.Date));
    if HomeTime = 0 then
    begin
      ShowMessage('Bitte geben Sie eine Zeit ein');
      Result := False;
      Exit;
    end;

    if Value.KoppelDate then
    begin
      if Value.KoppelSecondTime = 0 then
      begin
        ShowMessage('Bitte geben Sie eine zweite Zeit ein');
        Result := False;
        Exit;
      end;

      if Abs(HomeTime - Value.KoppelSecondTime) <= EncodeTime(3, 59, 0, 0) then
      begin
        ShowMessage('Zwischen dem ersten und zweiten Spiel mssen mindestens 4 Stunden liegen');
        Result := False;
        Exit;
      end;
    end;

    if Value.KoppelAuswaertsSecondTime then
    begin
      if Value.KoppelSecondTime = 0 then
      begin
        ShowMessage('Bitte geben Sie eine zweite Zeit ein');
        Result := False;
        Exit;
      end;

      if Abs(HomeTime - Value.KoppelSecondTime) <= EncodeTime(3, 59, 0, 0) then
      begin
        ShowMessage('Zwischen dem ersten und zweiten Spiel mssen mindestens 4 Stunden liegen');
        Result := False;
        Exit;
      end;
    end;

  end;

end;



procedure TDialogEditOneHomeDay.CheckBoxAuswaertskoppelClick(Sender: TObject);
begin
  EnableButtons();
end;

procedure TDialogEditOneHomeDay.ComboBoxChange(Sender: TObject);
begin
  EnableButtons();
end;

procedure TDialogEditOneHomeDay.ComboBoxKoppelChange(Sender: TObject);
begin
  EnableButtons;
end;

procedure TDialogEditOneHomeDay.ComboBoxPrioChange(Sender: TObject);
begin
  EnableButtons;
end;

procedure TDialogEditOneHomeDay.EnableButtons();
begin
  PanelHomeDayData.Visible := (ComboBox.ItemIndex = 1);

  LabelKoppelSecondTime.Enabled := ComboBoxKoppel.ItemIndex = 1;
  TimePickerKoppelTime.Enabled := LabelKoppelSecondTime.Enabled;

  LabelKoppelPrio.Enabled := ComboBoxKoppel.ItemIndex <> 0;
  ComboBoxPrio.Enabled := LabelKoppelPrio.Enabled;

  if ComboBoxKoppel.ItemIndex = 1 then
  begin
    CheckBoxAuswaertskoppel.Checked := false;
    CheckBoxAuswaertskoppel.Enabled := False;
  end
  else
  begin
    CheckBoxAuswaertskoppel.Enabled := True;
  end;

  TimePickerSecondTimeAuswaertskoppel.Enabled := CheckBoxAuswaertskoppel.Checked;
  LabelAuswaertsKoppelTime.Enabled := TimePickerSecondTimeAuswaertskoppel.Enabled;

  LabelAuswaertsKoppel.Enabled := CheckBoxAuswaertskoppel.Enabled;


end;

procedure TDialogEditOneHomeDay.FormCreate(Sender: TObject);
begin
  Value := THomeDay.Create;
  FixControls(Self);
end;

procedure TDialogEditOneHomeDay.FormDestroy(Sender: TObject);
begin
  Value.Free;
end;

function TDialogEditOneHomeDay.GetValue: THomeDay;
begin
  Result := Value;
end;

procedure TDialogEditOneHomeDay.SetValue(PlanData: TPlanData; TeamName: String; Value: THomeDay; Date: TDateTime);
begin
  LabelDate.Caption := 'Datum: ' + FormatDateForExport(Date);
  Self.Value.Assign(Value);

  PlanData.getTeamLocationsInt(ComboLocation.Items);

  if Value.NoDate then
  begin
    ComboBox.ItemIndex := 0;
  end
  else
  if Value.SperrTermin then
  begin
    ComboBox.ItemIndex := 2;
  end
  else
  begin
    ComboBox.ItemIndex := 1;
    TimePicker.Time := Value.Date;
    ComboBoxMaxGames.ItemIndex := Value.MaxParallelGame;
    CheckBoxAusweich.Checked := Value.AusweichTermin;
    SetListComboValue(ComboLocation, Value.Location);

    ComboBoxKoppel.ItemIndex := 0;
    if Value.KoppelDate then
    begin
      ComboBoxKoppel.ItemIndex := 1;
      TimePickerKoppelTime.Time := Value.KoppelSecondTime;
      ComboBoxPrio.ItemIndex := Value.KoppelPrio;
    end
    else
    begin
      if Value.KoppelAuswaertsSecondTime then
      begin
        CheckBoxAuswaertskoppel.Checked := true;
        TimePickerSecondTimeAuswaertskoppel.Time := Value.KoppelSecondTime;
      end;
    end;
    if Value.DoubleDate then
    begin
      ComboBoxKoppel.ItemIndex := 2;
      ComboBoxPrio.ItemIndex := Value.KoppelPrio;
    end;
  end;

  EnableButtons();
end;

end.
