unit DialogEditOneGame;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  System.UITypes, Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ComCtrls, PlanTypes,
  Vcl.ExtCtrls, Vcl.Grids, PlanUtils, PlanDataObjects;

type
  TDialogEditOneGame = class(TForm)
    PanelBottom: TPanel;
    ButtonOK: TButton;
    ButtonCancel: TButton;
    PanelHomeDayData: TPanel;
    TimePicker: TDateTimePicker;
    Label4: TLabel;
    Label1: TLabel;
    ComboHomeTeam: TComboBox;
    ComboGuestTeam: TComboBox;
    Label2: TLabel;
    ComboLocation: TComboBox;
    LabelKoppelPrio: TLabel;
    DatePicker: TDateTimePicker;
    Label3: TLabel;
    procedure ButtonCancelClick(Sender: TObject);
    procedure ButtonOKClick(Sender: TObject);
    procedure ComboHomeTeamChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
    PlanData: TPlanData;
    procedure EnableButtons;
  public
    { Public-Deklarationen }
    procedure SetValue(PlanData: TPlanData; Value: TDataObject);
    procedure GetValue(Value: TDataObject);
  end;


implementation

{$R *.dfm}

procedure TDialogEditOneGame.ButtonCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TDialogEditOneGame.ButtonOKClick(Sender: TObject);
begin
  if ComboHomeTeam.ItemIndex < 0 then
  begin
    ShowMessage('Keine Heimmanschaft angegeben');
  end
  else
  if ComboGuestTeam.ItemIndex < 0 then
  begin
    ShowMessage('Keine Gastmanschaft angegeben');
  end
  else
  if ComboGuestTeam.ItemIndex = ComboHomeTeam.ItemIndex then
  begin
    ShowMessage('Die Mannschaft kann nicht gegen sich selbst spielen');
  end
  else
  begin
    ModalResult := mrOk;
  end;
end;




procedure TDialogEditOneGame.ComboHomeTeamChange(Sender: TObject);
begin
  EnableButtons();
end;

procedure TDialogEditOneGame.EnableButtons();
var
  HomeTeamName: String;
begin
  HomeTeamName := '';

  if ComboHomeTeam.ItemIndex >= 0  then
  begin
    HomeTeamName := ComboHomeTeam.Items[ComboHomeTeam.ItemIndex];
  end;
end;




procedure TDialogEditOneGame.FormCreate(Sender: TObject);
begin
  FixControls(Self);
end;

procedure TDialogEditOneGame.GetValue(Value: TDataObject);
begin
  Value.SetAsDateTime(aDateTime, FixDateTime(Trunc(DatePicker.DateTime) + TimePicker.DateTime - Trunc(TimePicker.DateTime)));
  Value.SetAsString(aHomeTeamName, ComboHomeTeam.Items[ComboHomeTeam.ItemIndex]);
  Value.SetAsString(aGuestTeamName, ComboGuestTeam.Items[ComboGuestTeam.ItemIndex]);
  Value.SetAsString(aLocation, GetListComboValue(ComboLocation));
end;

procedure TDialogEditOneGame.SetValue(PlanData: TPlanData; Value: TDataObject);
begin
  Self.PlanData := PlanData;
  PlanData.getTeamNames(ComboHomeTeam.Items);
  PlanData.getTeamNames(ComboGuestTeam.Items);

  PlanData.getTeamLocationsInt(ComboLocation.Items);
  DatePicker.DateTime := Trunc(PlanData.root.GetAsDate(aFrom));

  if Assigned(Value) then
  begin
    DatePicker.DateTime := Trunc(Value.GetAsDateTime(aDateTime));
    TimePicker.DateTime := Value.GetAsDateTime(aDateTime) - Trunc(Value.GetAsDateTime(aDateTime));
    ComboHomeTeam.ItemIndex := ComboHomeTeam.Items.IndexOf(Value.GetAsString(aHomeTeamName));
    ComboGuestTeam.ItemIndex := ComboGuestTeam.Items.IndexOf(Value.GetAsString(aGuestTeamName));
    SetListComboValue(ComboLocation, Value.GetAsString(aLocation));
  end;

end;

end.
