unit DialogEditOneAuswaertsKoppel;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  System.UITypes, Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ComCtrls, PlanTypes,
  Vcl.ExtCtrls, Vcl.Grids, PlanUtils, PlanDataObjects;

type
  TDialogEditOneAuswaertsKoppel = class(TForm)
    PanelBottom: TPanel;
    ButtonOK: TButton;
    ButtonCancel: TButton;
    PanelHomeDayData: TPanel;
    Label1: TLabel;
    ComboTeamA: TComboBox;
    ComboTeamB: TComboBox;
    Label3: TLabel;
    ComboArt: TComboBox;
    Label4: TLabel;
    procedure ButtonCancelClick(Sender: TObject);
    procedure ButtonOKClick(Sender: TObject);
    procedure ComboTeamAChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
    procedure EnableButtons;
  public
    { Public-Deklarationen }
    procedure SetValue(PlanData: TPlanData; Value: TDataObject; MainTeamName: String);
    procedure GetValue(Value: TDataObject);
  end;


implementation

{$R *.dfm}

procedure TDialogEditOneAuswaertsKoppel.ButtonCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TDialogEditOneAuswaertsKoppel.ButtonOKClick(Sender: TObject);
begin
  if ComboTeamA.ItemIndex < 0 then
  begin
    ShowMessage('Bitte Mannschaft 1 angegeben');
  end
  else
  if ComboTeamB.ItemIndex < 0 then
  begin
    ShowMessage('Bitte Mannschaft 2 angegeben');
  end
  else
  if ComboTeamA.ItemIndex = ComboTeamB.ItemIndex then
  begin
    ShowMessage('Mannschaft 1 und 2 mssen unterschiedlich sein');
  end
  else
  begin
    ModalResult := mrOk;
  end;
end;




procedure TDialogEditOneAuswaertsKoppel.ComboTeamAChange(Sender: TObject);
begin
  EnableButtons();
end;

procedure TDialogEditOneAuswaertsKoppel.EnableButtons();
begin
end;




procedure TDialogEditOneAuswaertsKoppel.FormCreate(Sender: TObject);
begin
  FixControls(Self);
end;

procedure TDialogEditOneAuswaertsKoppel.GetValue(Value: TDataObject);
begin
  Value.SetAsString(aTeamNameA, ComboTeamA.Items[ComboTeamA.ItemIndex]);
  Value.SetAsString(aTeamNameB, ComboTeamB.Items[ComboTeamB.ItemIndex]);
  Value.SetAsInt(aSameDay, ComboArt.ItemIndex);
end;

procedure TDialogEditOneAuswaertsKoppel.SetValue(PlanData: TPlanData; Value: TDataObject; MainTeamName: String);
var
  Teams: TStrings;
begin
  Teams := TStringList.Create;
  PlanData.getTeamNames(Teams);
  if 0 <= Teams.IndexOf(MainTeamName) then
  begin
    Teams.Delete(Teams.IndexOf(MainTeamName));
  end;

  ComboTeamA.Items := Teams;
  ComboTeamB.Items := Teams;

  if Assigned(Value) then
  begin
    ComboTeamA.ItemIndex := ComboTeamA.Items.IndexOf(Value.GetAsString(aTeamNameA));
    ComboTeamB.ItemIndex := ComboTeamB.Items.IndexOf(Value.GetAsString(aTeamNameB));

    ComboArt.ItemIndex := Value.GetAsInt(aSameDay);
  end;

  Teams.Free;
end;

end.
