unit DialogCreateTestData;

(*
Copyright 2017 Andreas Hofmann
Lizenz:
Der Sourcecode steht unter der GPL V3
siehe <http://www.gnu.org/licenses/>.
*)


interface

uses
  System.UITypes, Winapi.Windows, Winapi.Messages, Vcl.StdCtrls, Vcl.Controls, Vcl.ExtCtrls, Vcl.Forms, System.SysUtils,
  Vcl.ComCtrls, System.Classes, PlanTypes, System.Generics.Collections, System.Generics.Defaults,
  Dialogs, Vcl.Menus, PlanUtils, Winapi.ShellAPI, System.TypInfo, SyncObjs, System.IOUtils;

type

  TFormTestData = class(TForm)
    ButtonOK: TButton;
    PanelBottom: TPanel;
    ButtonSave: TButton;
    SaveDialog: TSaveDialog;
    Label1: TLabel;
    Memo1: TMemo;
    Label2: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    EditSperrBis: TEdit;
    EditSperrVon: TEdit;
    Label3: TLabel;
    procedure ButtonOKClick(Sender: TObject);
    procedure ButtonSaveClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
  public
    { Public-Deklarationen }
    Plan: TPlan;
    function GetSpieltagDiff: integer;
    function GetNumSpieltage: integer;
    function GetNumSperrTermine: Integer;

  end;


procedure ShowDialog(Plan: TPlan);


implementation

{$R *.dfm}


procedure ShowDialog(Plan: TPlan);
var
  Dlg: TFormTestData;
begin
  Dlg := TFormTestData.Create(nil);
  Dlg.Plan := Plan;
  Dlg.ShowModal();
  Dlg.Free;
end;




procedure TFormTestData.ButtonOKClick(Sender: TObject);
begin
  ModalResult := mrOK;
end;


function TFormTestData.GetSpieltagDiff(): integer;
var
  s: String;
begin
  Result := 0;

  s := AnsiUpperCase(Memo1.Lines[Random(Memo1.Lines.Count)]);

  if s = 'MO' then
    Result := 0;

  if s = 'DI' then
    Result := 1;

  if s = 'MI' then
    Result := 2;

  if s = 'DO' then
    Result := 3;

  if s = 'FR' then
    Result := 4;

  if s = 'SA' then
    Result := 5;

  if s = 'SO' then
    Result := 6;

end;


function TFormTestData.GetNumSperrTermine(): Integer;
var
  a,b: integer;
begin
  a := StrToInt(EditSperrVon.Text);
  b := StrToInt(EditSperrBis.Text);

  result := a + Random(b-a);
end;


function TFormTestData.GetNumSpieltage(): integer;
var
  a,b: integer;
begin
  a := StrToInt(Edit1.Text);
  b := StrToInt(Edit2.Text);

  result := a + Random(b-a);

end;

procedure TFormTestData.ButtonSaveClick(Sender: TObject);
(*
var
  SavePlan: TPlan;
  SpieltageMondaysVorrunde: TList<TDateTime>;
  SpieltageMondaysRueckrunde: TList<TDateTime>;
  SpieltageMondaysWork: TList<TDateTime>;
  SpieltageMondaysAll: TList<TDateTime>;
  Mannschaft: TMannschaft;
  SpieltagDiff: integer;
  NumSpielTage, NumSperrTermine: integer;
  I: Integer;
  Date: TDateTime;
  terminiert: integer;
  j: Integer;
  WunschTermin: TWunschTermin;
*)
begin
  (*ARBEIT
  if SaveDialog.Execute() then
  begin
    SavePlan := TPlan.Create;
    SavePlan.Assign(Plan);

    SavePlan.PlanName := TPath.GetFileNameWithoutExtension(SaveDialog.FileName);

    SavePlan.clearAllDates();

    SpieltageMondaysVorrunde := TList<TDateTime>.Create;
    SpieltageMondaysRueckrunde := TList<TDateTime>.Create;
    SpieltageMondaysAll := TList<TDateTime>.Create;

    SavePlan.getSpieltagMondays(SpieltageMondaysVorrunde, SavePlan.DateBegin, SavePlan.DateBeginRueckrundeInXML);
    SavePlan.getSpieltagMondays(SpieltageMondaysRueckrunde, SavePlan.DateBeginRueckrundeInXML, SavePlan.DateEnd);
    SavePlan.getSpieltagMondays(SpieltageMondaysAll, SavePlan.DateBegin, SavePlan.DateEnd);

    for Mannschaft in SavePlan.Mannschaften do
    begin
      Mannschaft.WunschTermine.Clear;
      Mannschaft.SperrTermine.Clear;
      Mannschaft.AuswaertsKoppelInXML.Clear;

      SpieltagDiff := GetSpieltagDiff();
      NumSpielTage := GetNumSpielTage();
      NumSperrTermine := GetNumSperrTermine();


      // Wunschtermine
      for j := 0 to 1 do
      begin
        terminiert := 0;
        for I := 0 to 200 do
        begin
          if terminiert >= NumSpielTage then
          begin
            break;
          end;

          if j = 0 then
          begin
            SpieltageMondaysWork := SpieltageMondaysVorrunde;
          end
          else
          begin
            SpieltageMondaysWork := SpieltageMondaysRueckrunde;
          end;

          Date := SpieltageMondaysWork[Random(SpieltageMondaysWork.Count)];

          Date := Date + SpieltagDiff + EncodeTime(15, 0, 0, 0);
          if not Mannschaft.WunschTermine.Exists(Date) then
          begin
            WunschTermin := TWunschTermin.Create;
            WunschTermin.Date := Date;
            Mannschaft.WunschTermine.Add(WunschTermin);
            Inc(terminiert);
          end;
        end;
      end;

      // Sperrtermine
      terminiert := 0;
      for I := 0 to 200 do
      begin
        if terminiert >= NumSperrTermine then
        begin
          break;
        end;

        Date := SpieltageMondaysAll[Random(SpieltageMondaysAll.Count)];

        Date := Date + GetSpieltagDiff();
        if not Mannschaft.WunschTermine.ExistsIgnoreTime(Date) then
        begin
          if not Mannschaft.SperrTermine.Contains(Date) then
          begin
            Mannschaft.SperrTermine.Add(Date);
            Inc(terminiert);
          end;
        end;
      end;
    end;



    SpieltageMondaysVorrunde.Free;
    SpieltageMondaysRueckrunde.Free;
    SpieltageMondaysAll.Free;

    SavePlan.SaveToXML(SaveDialog.FileName);

    SavePlan.Free;
  end;
  *)
end;

procedure TFormTestData.FormCreate(Sender: TObject);
begin
  FixControls(Self);
end;

end.
